/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.python.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC74")
@DeprecatedRuleKey(repositoryKey="gci-python", ruleKey="S74")
public class AvoidFullSQLRequest
extends PythonSubscriptionCheck {
    protected static final String MESSAGERULE = "Don't use the query SELECT * FROM";
    private static final Pattern PATTERN = Pattern.compile("(?i).*select.*\\*.*from.*");
    private static final Map<String, Collection<Integer>> linesWithIssuesByFile = new HashMap<String, Collection<Integer>>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_LITERAL, this::visitNodeString);
    }

    public void visitNodeString(SubscriptionContext ctx) {
        StringLiteral stringLiteral = (StringLiteral)ctx.syntaxNode();
        stringLiteral.stringElements().forEach(stringElement -> this.checkIssue((StringElement)stringElement, ctx));
    }

    public void checkIssue(StringElement stringElement, SubscriptionContext ctx) {
        if (this.lineAlreadyHasThisIssue(stringElement, ctx)) {
            return;
        }
        if (PATTERN.matcher(stringElement.value()).matches()) {
            this.repport(stringElement, ctx);
        }
    }

    private void repport(StringElement stringElement, SubscriptionContext ctx) {
        if (stringElement.firstToken() != null) {
            String classname = ctx.pythonFile().fileName();
            int line = stringElement.firstToken().line();
            linesWithIssuesByFile.computeIfAbsent(classname, k -> new ArrayList());
            linesWithIssuesByFile.get(classname).add(line);
        }
        ctx.addIssue((Tree)stringElement, MESSAGERULE);
    }

    private boolean lineAlreadyHasThisIssue(StringElement stringElement, SubscriptionContext ctx) {
        if (stringElement.firstToken() != null) {
            String filename = ctx.pythonFile().fileName();
            int line = stringElement.firstToken().line();
            return linesWithIssuesByFile.containsKey(filename) && linesWithIssuesByFile.get(filename).contains(line);
        }
        return false;
    }
}

