/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.python.checks;

import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="EC404")
public class AvoidListComprehensionInIterations
extends PythonSubscriptionCheck {
    public static final String DESCRIPTION = "Use generator comprehension instead of list comprehension in for loop declaration";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FOR_STMT, this::visitIteration);
    }

    private void visitIteration(SubscriptionContext context) {
        ForStatement forStatement = (ForStatement)context.syntaxNode();
        Expression forTestExpression = (Expression)forStatement.testExpressions().get(0);
        if (forTestExpression.is(new Tree.Kind[]{Tree.Kind.LIST_COMPREHENSION})) {
            context.addIssue(forTestExpression.firstToken(), DESCRIPTION);
        } else if (forTestExpression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            CallExpression callExpression = (CallExpression)forTestExpression;
            this.visitCallExpression(context, callExpression);
        }
    }

    private void visitCallExpression(SubscriptionContext context, CallExpression callExpression) {
        switch (this.getFunctionNameFromCallExpression(callExpression)) {
            case "zip": 
            case "filter": 
            case "enumerate": {
                Objects.requireNonNull(callExpression.argumentList()).arguments().forEach(e -> this.visitFunctionArgument(context, (Tree)e));
                break;
            }
        }
    }

    private void visitFunctionArgument(SubscriptionContext context, Tree argument) {
        if (argument.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})) {
            Expression expression = ((RegularArgument)argument).expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.LIST_COMPREHENSION})) {
                context.addIssue(expression.firstToken(), DESCRIPTION);
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
                CallExpression callExpression = (CallExpression)expression;
                this.visitCallExpression(context, callExpression);
            }
        }
    }

    private String getFunctionNameFromCallExpression(CallExpression callExpression) {
        Symbol symbol = callExpression.calleeSymbol();
        return symbol != null && symbol.name() != null ? symbol.name() : "";
    }
}

