/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import io.featureflow.client.FeatureControlCallbackHandler;
import io.featureflow.client.FeatureflowClientImpl;
import io.featureflow.client.FeatureflowConfig;
import io.featureflow.client.FeatureflowContext;
import io.featureflow.client.core.CallbackEvent;
import io.featureflow.client.model.Feature;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface FeatureflowClient<E extends Enum<E>>
extends Closeable {
    public Evaluate evaluate(String var1, FeatureflowContext var2);

    public Evaluate evaluate(String var1);

    public Map<String, String> evaluateAll(FeatureflowContext var1);

    public static Builder builder(String apiKey) {
        return new Builder(apiKey);
    }

    public static class Evaluate {
        private String evaluateResult;

        Evaluate(FeatureflowClientImpl featureflowClient, String featureKey, FeatureflowContext featureflowContext) {
            this.evaluateResult = featureflowClient.eval(featureKey, featureflowContext);
        }

        public boolean isOn() {
            return this.is("on");
        }

        public boolean isOff() {
            return this.is("off");
        }

        public boolean is(String variant) {
            return variant.equals(this.evaluateResult);
        }

        public String value() {
            return this.evaluateResult;
        }
    }

    public static class Builder {
        private FeatureflowConfig config = null;
        private String apiKey;
        private Map<CallbackEvent, List<FeatureControlCallbackHandler>> featureControlCallbackHandlers = new HashMap<CallbackEvent, List<FeatureControlCallbackHandler>>();
        private List<Feature> features = new ArrayList<Feature>();

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder withUpdateCallback(FeatureControlCallbackHandler featureControlCallbackHandler) {
            this.withCallback(CallbackEvent.UPDATED_FEATURE, featureControlCallbackHandler);
            return this;
        }

        public Builder withDeleteCallback(FeatureControlCallbackHandler featureControlCallbackHandler) {
            this.withCallback(CallbackEvent.DELETED_FEATURE, featureControlCallbackHandler);
            return this;
        }

        @Deprecated
        public Builder withCallback(FeatureControlCallbackHandler featureControlCallbackHandler) {
            this.withUpdateCallback(featureControlCallbackHandler);
            return this;
        }

        public Builder withCallback(CallbackEvent event, FeatureControlCallbackHandler featureControlCallbackHandler) {
            if (this.featureControlCallbackHandlers.get((Object)event) == null) {
                this.featureControlCallbackHandlers.put(event, new ArrayList());
            }
            this.featureControlCallbackHandlers.get((Object)event).add(featureControlCallbackHandler);
            return this;
        }

        public Builder withConfig(FeatureflowConfig config) {
            this.config = config;
            return this;
        }

        public Builder withFeature(Feature feature) {
            this.features.add(feature);
            return this;
        }

        public Builder withFeatures(List<Feature> features) {
            this.features = features;
            return this;
        }

        public FeatureflowClient build() {
            if (this.config == null) {
                this.config = new FeatureflowConfig.Builder().build();
            }
            return new FeatureflowClientImpl(this.apiKey, this.features, this.config, this.featureControlCallbackHandlers);
        }
    }
}

