/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import io.featureflow.client.ConnectionHandler;
import io.featureflow.client.EventSourceHandler;
import io.featureflow.client.MessageEvent;
import java.net.URI;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStreamParser {
    private static final Logger logger = LoggerFactory.getLogger(EventStreamParser.class);
    private static final String DATA = "data";
    private static final String ID = "id";
    private static final String EVENT = "event";
    private static final String RETRY = "retry";
    private static final String DEFAULT_EVENT = "message";
    private static final String EMPTY_STRING = "";
    private static final Pattern DIGITS_ONLY = Pattern.compile("^[\\d]+$");
    private final EventSourceHandler eventSourceHandler;
    private final ConnectionHandler connectionHandler;
    private final URI origin;
    private StringBuffer data = new StringBuffer();
    private String lastEventId;
    private String eventName = "message";

    EventStreamParser(URI origin, EventSourceHandler eventSourceHandler, ConnectionHandler connectionHandler) {
        this.eventSourceHandler = eventSourceHandler;
        this.origin = origin;
        this.connectionHandler = connectionHandler;
    }

    public void line(String line) {
        logger.debug("Parsing line: " + line);
        if (line.trim().isEmpty()) {
            this.dispatchEvent();
        } else if (!line.startsWith(":")) {
            int colonIndex = line.indexOf(":");
            if (colonIndex != -1) {
                String field = line.substring(0, colonIndex);
                String value = line.substring(colonIndex + 1).replaceFirst(" ", EMPTY_STRING);
                this.processField(field, value);
            } else {
                this.processField(line.trim(), EMPTY_STRING);
            }
        }
    }

    private void processField(String field, String value) {
        if (DATA.equals(field)) {
            this.data.append(value).append("\n");
        } else if (ID.equals(field)) {
            this.lastEventId = value;
        } else if (EVENT.equals(field)) {
            this.eventName = value;
        } else if (RETRY.equals(field) && this.isNumber(value)) {
            this.connectionHandler.setReconnectionTimeMillis(Long.parseLong(value));
        }
    }

    private boolean isNumber(String value) {
        return DIGITS_ONLY.matcher(value).matches();
    }

    private void dispatchEvent() {
        if (this.data.length() == 0) {
            return;
        }
        String dataString = this.data.toString();
        if (dataString.endsWith("\n")) {
            dataString = dataString.substring(0, dataString.length() - 1);
        }
        MessageEvent message = new MessageEvent(dataString, this.lastEventId, this.origin);
        this.connectionHandler.setLastEventId(this.lastEventId);
        try {
            this.eventSourceHandler.onMessage(this.eventName, message);
        }
        catch (Exception e) {
            this.eventSourceHandler.onError(e);
        }
        this.data = new StringBuffer();
        this.eventName = DEFAULT_EVENT;
    }
}

