/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import io.featureflow.client.FeatureFlowContext;
import io.featureflow.client.Rule;
import io.featureflow.client.Variant;
import java.util.ArrayList;
import java.util.List;

public class FeatureControl {
    String id;
    String featureId;
    String key;
    String environmentId;
    String salt = "1";
    boolean enabled;
    boolean available;
    boolean deleted;
    List<Rule> rules = new ArrayList<Rule>();
    String offVariantKey;
    boolean inClientApi;
    List<Variant> variants = new ArrayList<Variant>();

    public String getKey() {
        return this.key;
    }

    public String evaluate(FeatureFlowContext context) {
        if (!this.enabled) {
            return this.offVariantKey;
        }
        for (Rule rule : this.rules) {
            if (!rule.matches(context)) continue;
            return rule.getVariantSplitKey(context.key, this.key, this.salt);
        }
        return null;
    }

    public Variant getVariantByKey(String key) {
        for (Variant v : this.variants) {
            if (!v.key.equals(key)) continue;
            return v;
        }
        return null;
    }

    public String toString() {
        return "FeatureControl{\n  key='" + this.key + '\'' + "\n" + "  environmentId='" + this.environmentId + '\'' + "\n" + "  enabled=" + this.enabled + "\n" + "  available=" + this.available + "\n" + "  deleted=" + this.deleted + "\n" + "  rules=" + this.rules.stream().map(r -> "Rule " + r.getPriority() + ": " + r.getVariantSplits().stream().map(s -> s.getVariantKey() + ":" + s.getSplit() + "% ").reduce("", String::concat) + "\n").reduce("", String::concat) + "\n" + "  offVariantKey=" + this.offVariantKey + "\n" + "  inClientApi=" + this.inClientApi + "\n" + "  variants=" + (this.variants == null ? null : this.variants.stream().map(v -> v.name + " ").reduce("", String::concat)) + "\n" + '}';
    }
}

