/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.featureflow.client.EventSource;
import io.featureflow.client.EventSourceHandler;
import io.featureflow.client.FeatureControl;
import io.featureflow.client.FeatureControlCache;
import io.featureflow.client.FeatureControlUpdateHandler;
import io.featureflow.client.FeatureFlowConfig;
import io.featureflow.client.MessageEvent;
import io.featureflow.client.NoOpFuture;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureControlStreamClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(FeatureControlStreamClient.class);
    private final FeatureFlowConfig config;
    private final FeatureControlCache repository;
    private final FeatureControlUpdateHandler callback;
    private EventSource eventSource;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private String apiKey;

    public FeatureControlStreamClient(String apiKey, FeatureFlowConfig config, FeatureControlCache repository, FeatureControlUpdateHandler callback) {
        this.apiKey = apiKey;
        this.config = config;
        this.repository = repository;
        this.callback = callback;
    }

    public Future<Void> start() {
        NoOpFuture initFuture = new NoOpFuture();
        Headers headers = new Headers.Builder().add("Authorization", "Bearer " + this.apiKey).add("User-Agent", "FeatureflowClient-Java/1.0").add("Cache-Control", "no-cache").build();
        this.eventSource = new EventSource(this.config.getControlStreamUri(), 5000L, headers, this.getHandler(initFuture));
        this.eventSource.init();
        return initFuture;
    }

    private EventSourceHandler getHandler(final NoOpFuture initFuture) {
        EventSourceHandler handler = new EventSourceHandler(){

            @Override
            public void onConnect() throws Exception {
                logger.info("Featureflow Connected");
            }

            @Override
            public void onMessage(String name, MessageEvent event) throws Exception {
                Gson gson = new Gson();
                if (event.getData().startsWith("{\"heartbeat\"")) {
                    if (!FeatureControlStreamClient.this.initialized.getAndSet(true)) {
                        initFuture.completed(null);
                        logger.info("Featureflow client inititalised.");
                    }
                    return;
                }
                Type type = new TypeToken<Map<String, FeatureControl>>(){}.getType();
                Map controls = (Map)gson.fromJson(event.getData(), type);
                for (Map.Entry entry : controls.entrySet()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Received Message to update feature {} with {}.", entry.getKey(), (Object)((FeatureControl)entry.getValue()).enabled);
                    }
                    FeatureControlStreamClient.this.repository.update((String)entry.getKey(), (FeatureControl)entry.getValue());
                    if (FeatureControlStreamClient.this.callback == null) continue;
                    FeatureControlStreamClient.this.callback.onUpdate((FeatureControl)entry.getValue());
                }
                if (!FeatureControlStreamClient.this.initialized.getAndSet(true)) {
                    initFuture.completed(null);
                    logger.info("Featureflow client initialised.");
                }
            }

            @Override
            public void onError(Throwable throwable) {
                logger.warn("Error", throwable);
            }
        };
        return handler;
    }

    @Override
    public void close() throws IOException {
        if (this.eventSource != null) {
            this.eventSource.close();
        }
        if (this.repository != null) {
            this.repository.close();
        }
    }

    public boolean initialized() {
        return this.initialized.get();
    }
}

