/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import io.featureflow.client.Feature;
import io.featureflow.client.FeatureControlUpdateHandler;
import io.featureflow.client.FeatureFlowClientImpl;
import io.featureflow.client.FeatureFlowConfig;
import io.featureflow.client.FeatureFlowContext;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;

public interface FeatureFlowClient<E extends Enum<E>>
extends Closeable {
    public Evaluate evaluate(String var1, FeatureFlowContext var2);

    public Evaluate evaluate(String var1);

    public static Builder builder(String apiKey) {
        return new Builder(apiKey);
    }

    public static class Evaluate {
        private String evaluateResult;

        Evaluate(FeatureFlowClientImpl featureflowClient, String featureKey, FeatureFlowContext featureflowContext) {
            this.evaluateResult = featureflowClient.eval(featureKey, featureflowContext);
        }

        public boolean isOn() {
            return this.is("on");
        }

        public boolean isOff() {
            return this.is("off");
        }

        public boolean is(String variant) {
            return variant.equals(this.evaluateResult);
        }

        public String value() {
            return this.evaluateResult;
        }
    }

    public static class Builder {
        private FeatureFlowConfig config = null;
        private String apiKey;
        private FeatureControlUpdateHandler featureControlUpdateHandler;
        private List<Feature> features = new ArrayList<Feature>();

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder withCallback(FeatureControlUpdateHandler featureControlUpdateHandler) {
            this.featureControlUpdateHandler = featureControlUpdateHandler;
            return this;
        }

        public Builder withConfig(FeatureFlowConfig config) {
            this.config = config;
            return this;
        }

        public Builder withFeature(Feature feature) {
            this.features.add(feature);
            return this;
        }

        public Builder withFeatures(List<Feature> features) {
            this.features = features;
            return this;
        }

        public FeatureFlowClient build() {
            if (this.config == null) {
                this.config = new FeatureFlowConfig.Builder().build();
            }
            return new FeatureFlowClientImpl(this.apiKey, this.features, this.config, this.featureControlUpdateHandler);
        }
    }
}

