/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.featureflow.client.Feature;
import io.featureflow.client.FeatureControl;
import io.featureflow.client.FeatureControlCache;
import io.featureflow.client.FeatureControlEventHandler;
import io.featureflow.client.FeatureControlStreamClient;
import io.featureflow.client.FeatureControlUpdateHandler;
import io.featureflow.client.FeatureFlowClient;
import io.featureflow.client.FeatureFlowConfig;
import io.featureflow.client.FeatureFlowContext;
import io.featureflow.client.FeatureflowRestClient;
import io.featureflow.client.SimpleMemoryFeatureCache;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFlowClientImpl
implements FeatureFlowClient {
    private static final Logger logger = LoggerFactory.getLogger(FeatureFlowClientImpl.class);
    private final FeatureFlowConfig config;
    private final FeatureControlStreamClient featureControlStreamClient;
    private final FeatureControlCache featureControlCache;
    private final FeatureflowRestClient featureflowRestClient;
    private final FeatureControlEventHandler featureControlEventHandler;
    private final Map<String, Feature> featuresMap = new HashMap<String, Feature>();
    private Queue<FeatureControlUpdateHandler> handlers;

    FeatureFlowClientImpl(String apiKey, List<Feature> features, FeatureFlowConfig config, FeatureControlUpdateHandler callback) {
        this.config = config;
        this.featureControlCache = new SimpleMemoryFeatureCache();
        this.featureflowRestClient = new FeatureflowRestClient(apiKey, config);
        this.featureControlStreamClient = new FeatureControlStreamClient(apiKey, config, this.featureControlCache, callback);
        this.featureControlEventHandler = new FeatureControlEventHandler(this.featureflowRestClient);
        if (features != null && features.size() > 0) {
            for (Feature feature : features) {
                this.featuresMap.put(feature.key, feature);
            }
            try {
                this.featureflowRestClient.registerFeatureControls(features);
            }
            catch (IOException e) {
                logger.error("Problem registering reature controls", (Throwable)e);
            }
        }
        Future<Void> startFuture = this.featureControlStreamClient.start();
        if (config.waitForStartup > 0L) {
            logger.info("Waiting for Featureflow to inititalise");
            try {
                startFuture.get(20000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                logger.error("Timeout waiting for Featureflow client initialise");
            }
            catch (Exception e) {
                logger.error("Exception waiting for Featureflow client to initialise", (Throwable)e);
            }
        }
    }

    @Override
    public FeatureFlowClient.Evaluate evaluate(String featureKey, FeatureFlowContext featureFlowContext) {
        FeatureFlowClient.Evaluate e = new FeatureFlowClient.Evaluate(this, featureKey, featureFlowContext);
        return e;
    }

    @Override
    public FeatureFlowClient.Evaluate evaluate(String featureKey) {
        FeatureFlowContext featureFlowContext = FeatureFlowContext.context().build();
        return this.evaluate(featureKey, featureFlowContext);
    }

    protected String eval(String featureKey, FeatureFlowContext featureFlowContext) {
        String failoverVariant;
        String string = failoverVariant = this.featuresMap.get(featureKey) != null ? this.featuresMap.get((Object)featureKey).failoverVariant : "off";
        if (!this.featureControlStreamClient.initialized()) {
            logger.warn("FeatureFlow is not initialized yet, returning default value");
            return failoverVariant;
        }
        FeatureControl control = this.featureControlCache.get(featureKey);
        this.addAdditionalContext(featureFlowContext);
        if (control == null) {
            logger.error("Unknown Feature {}, returning failoverVariant value of {}", (Object)featureKey, (Object)failoverVariant);
            this.featureControlEventHandler.saveEvent(null, featureKey, failoverVariant, featureFlowContext);
            return failoverVariant;
        }
        String variant = control.evaluate(featureFlowContext);
        this.featureControlEventHandler.saveEvent(control.featureId, featureKey, variant, featureFlowContext);
        return variant;
    }

    private void addAdditionalContext(FeatureFlowContext featureFlowContext) {
        featureFlowContext.values.put("featureflow.date", (JsonElement)new JsonPrimitive(FeatureFlowContext.Builder.toIso(new DateTime())));
    }

    @Override
    public void close() throws IOException {
    }
}

