/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import java.net.URI;
import org.apache.http.HttpHost;

public class FeatureFlowConfig {
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 20000;
    public static final String DEFAULT_BASE_URI = "https://app.featureflow.io";
    public static final String DEFAULT_STREAM_BASE_URI = "https://rtm.featureflow.io";
    private static final String DEFAULT_CONTROL_STREAM_PATH = "/api/sdk/v1/controls/stream";
    static final String FEATURE_CONTROL_REST_PATH = "/api/sdk/v1/feature-controls";
    static final String REGISTER_REST_PATH = "/api/sdk/v1/register";
    static final String EVENTS_REST_PATH = "/api/sdk/v1/events";
    private boolean offline = false;
    String proxyHost = null;
    String proxyScheme = null;
    int proxyPort = -1;
    int connectTimeout = 30000;
    int socketTimeout = 20000;
    String baseUri = "https://app.featureflow.io";
    String streamBaseUri = "https://rtm.featureflow.io";
    String controlStreamPath = "/api/sdk/v1/controls/stream";
    long waitForStartup = 10000L;

    FeatureFlowConfig(boolean offline, String proxyHost, String proxyScheme, int proxyPort, int connectTimeout, int socketTimeout, String baseURI, String streamBaseUri, long waitForStartup) {
        this.offline = offline;
        this.proxyHost = proxyHost;
        this.proxyScheme = proxyScheme;
        this.proxyPort = proxyPort;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.baseUri = baseURI == null ? DEFAULT_BASE_URI : baseURI;
        this.streamBaseUri = streamBaseUri == null ? DEFAULT_STREAM_BASE_URI : streamBaseUri;
        this.waitForStartup = waitForStartup;
    }

    HttpHost getHttpProxyHost() {
        if (this.proxyHost == null && this.proxyPort == -1 && this.proxyScheme == null) {
            return null;
        }
        String hostname = this.proxyHost == null ? "localhost" : this.proxyHost;
        String scheme = this.proxyScheme == null ? "https" : this.proxyScheme;
        return new HttpHost(hostname, this.proxyPort, scheme);
    }

    boolean isOffline() {
        return this.offline;
    }

    void setOffline(boolean offline) {
        this.offline = offline;
    }

    String getProxyHost() {
        return this.proxyHost;
    }

    void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    String getProxyScheme() {
        return this.proxyScheme;
    }

    void setProxyScheme(String proxyScheme) {
        this.proxyScheme = proxyScheme;
    }

    int getProxyPort() {
        return this.proxyPort;
    }

    void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    int getConnectTimeout() {
        return this.connectTimeout;
    }

    void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    int getSocketTimeout() {
        return this.socketTimeout;
    }

    void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    String getBaseUri() {
        return this.baseUri == null ? DEFAULT_BASE_URI : this.baseUri;
    }

    String getStreamBaseUri() {
        return this.streamBaseUri == null ? DEFAULT_STREAM_BASE_URI : this.streamBaseUri;
    }

    URI getControlStreamUri() {
        return this.controlStreamPath == null ? URI.create(this.getStreamBaseUri() + DEFAULT_CONTROL_STREAM_PATH) : URI.create(this.getStreamBaseUri() + this.controlStreamPath);
    }

    long getWaitForStartup() {
        return this.waitForStartup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean offline = false;
        private String proxyHost = null;
        private String proxyScheme = null;
        private int proxyPort = -1;
        private int connectTimeout = 30000;
        private int socketTimeout = 20000;
        private String baseURI = "https://app.featureflow.io";
        private String streamBaseUri = "https://rtm.featureflow.io";
        long waitForStartup = 10000L;

        public Builder withOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder withProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder withProxyScheme(String proxyScheme) {
            this.proxyScheme = proxyScheme;
            return this;
        }

        public Builder withProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder withBaseUri(String baseUri) {
            this.baseURI = baseUri;
            return this;
        }

        public Builder withStreamBaseUri(String streamBaseUri) {
            this.streamBaseUri = streamBaseUri;
            return this;
        }

        public Builder withWaitForStartup(long waitTimeMilliseconds) {
            this.waitForStartup = waitTimeMilliseconds;
            return this;
        }

        public FeatureFlowConfig build() {
            return new FeatureFlowConfig(this.offline, this.proxyHost, this.proxyScheme, this.proxyPort, this.connectTimeout, this.socketTimeout, this.baseURI, this.streamBaseUri, this.waitForStartup);
        }
    }

    class Event {
        int queueSize = 10000;

        Event() {
        }
    }
}

