/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import io.featureflow.client.FeatureControl;
import io.featureflow.client.FeatureControlCache;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SimpleMemoryFeatureCache
implements FeatureControlCache {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, FeatureControl> featureControls = new HashMap<String, FeatureControl>();
    private volatile boolean initialized = false;

    @Override
    public void init(Map<String, FeatureControl> featureControls) {
        try {
            this.lock.writeLock().lock();
            this.featureControls.clear();
            this.featureControls.putAll(featureControls);
            this.initialized = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureControl get(String key) {
        try {
            this.lock.readLock().lock();
            FeatureControl fc = this.featureControls.get(key);
            if (fc == null || fc.deleted) {
                FeatureControl featureControl = null;
                return featureControl;
            }
            FeatureControl featureControl = fc;
            return featureControl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, FeatureControl> getAll() {
        try {
            this.lock.readLock().lock();
            HashMap<String, FeatureControl> fc = new HashMap<String, FeatureControl>();
            for (Map.Entry<String, FeatureControl> entry : this.featureControls.entrySet()) {
                if (entry.getValue().deleted) continue;
                fc.put(entry.getKey(), entry.getValue());
            }
            HashMap<String, FeatureControl> hashMap = fc;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String key, FeatureControl featureControl) {
        try {
            this.lock.writeLock().lock();
            FeatureControl old = this.featureControls.get(key);
            if (old != null && featureControl.variants == null) {
                featureControl.variants = old.variants;
            }
            this.featureControls.put(key, featureControl);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void close() throws IOException {
    }
}

