/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class FeatureflowContext {
    private String key;
    private String bucketKey;
    private Map<String, JsonElement> values = new HashMap<String, JsonElement>();
    public static final String FEATUREFLOW_KEY = "featureflow.key";
    public static final String FEATUREFLOW_DATE = "featureflow.date";
    public static final String FEATUREFLOW_HOUROFDAY = "featureflow.hourofday";

    public FeatureflowContext() {
        this.key = "anonymous";
        this.values.put(FEATUREFLOW_KEY, (JsonElement)new JsonPrimitive(this.key));
    }

    public FeatureflowContext(String key) {
        this.key = key;
        this.values.put(FEATUREFLOW_KEY, (JsonElement)new JsonPrimitive(key));
        this.bucketKey = key;
    }

    public FeatureflowContext withBucketKey(String bucketKey) {
        this.bucketKey = bucketKey;
        return this;
    }

    public Map<String, JsonElement> getValues() {
        return this.values;
    }

    public FeatureflowContext withValue(String key, String value) {
        JsonPrimitive jsonValue = new JsonPrimitive(value);
        this.values.put(key, (JsonElement)jsonValue);
        return this;
    }

    public FeatureflowContext withValue(String key, DateTime value) {
        JsonPrimitive jsonValue = new JsonPrimitive(FeatureflowContext.toIso(value));
        this.values.put(key, (JsonElement)jsonValue);
        return this;
    }

    public FeatureflowContext withValue(String key, Number value) {
        JsonPrimitive jsonValue = new JsonPrimitive(value);
        this.values.put(key, (JsonElement)jsonValue);
        return this;
    }

    public FeatureflowContext withDateValues(String key, List<DateTime> values) {
        JsonArray vals = new JsonArray();
        for (DateTime value : values) {
            vals.add((JsonElement)new JsonPrimitive(FeatureflowContext.toIso(value)));
        }
        this.values.put(key, (JsonElement)vals);
        return this;
    }

    public FeatureflowContext withNumberValues(String key, List<Number> values) {
        JsonArray vals = new JsonArray();
        for (Number value : values) {
            vals.add((JsonElement)new JsonPrimitive(value));
        }
        this.values.put(key, (JsonElement)vals);
        return this;
    }

    public FeatureflowContext withStringValues(String key, List<String> values) {
        JsonArray vals = new JsonArray();
        for (String value : values) {
            vals.add((JsonElement)new JsonPrimitive(value));
        }
        this.values.put(key, (JsonElement)vals);
        return this;
    }

    public FeatureflowContext withValues(Map<String, JsonElement> values) {
        this.values.putAll(values);
        return this;
    }

    protected static String toIso(DateTime date) {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        String str = fmt.print((ReadableInstant)date);
        return str;
    }

    protected static DateTime fromIso(String isoDate) {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        DateTime dt = fmt.parseDateTime(isoDate);
        return dt;
    }

    public String getKey() {
        return this.key;
    }

    public String getBucketKey() {
        return this.bucketKey;
    }
}

