/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.featureflow.client.FeatureflowUser;
import io.featureflow.client.model.Operator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Condition {
    public String target;
    public Operator operator;
    public List<JsonPrimitive> values = new ArrayList<JsonPrimitive>();

    public Condition() {
    }

    public Condition(String target, Operator operator, List<JsonPrimitive> values) {
        this.target = target;
        this.operator = operator;
        this.values = values;
    }

    public boolean matches(FeatureflowUser user) {
        if (user == null || user.getAttributes() == null && user.getSessionAttributes() == null) {
            return false;
        }
        HashMap<String, JsonElement> combined = new HashMap<String, JsonElement>();
        combined.putAll(user.getAttributes());
        combined.putAll(user.getSessionAttributes());
        for (String attributeKey : combined.keySet()) {
            if (!attributeKey.equals(this.target)) continue;
            JsonElement contextValue = user.getAttributes().get(attributeKey);
            if (contextValue.isJsonArray()) {
                JsonArray ar = contextValue.getAsJsonArray();
                for (JsonElement jsonElement : ar) {
                    if (!this.operator.evaluate(jsonElement.getAsJsonPrimitive(), this.values)) continue;
                    return true;
                }
                return false;
            }
            return this.operator.evaluate(user.getAttributes().get(attributeKey).getAsJsonPrimitive(), this.values);
        }
        return false;
    }
}

