/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client.core;

import io.featureflow.client.FeatureflowConfig;
import io.featureflow.client.core.EventsClient;
import io.featureflow.client.core.RestClient;
import io.featureflow.client.model.Event;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class EventsClientImpl
implements EventsClient {
    private final BlockingQueue<Event> eventsQueue = new ArrayBlockingQueue<Event>(10000);
    private final RestClient restClient;

    public EventsClientImpl(FeatureflowConfig config, RestClient restClient) {
        this.restClient = restClient;
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
        final Sender sender = new Sender();
        executorService.scheduleAtFixedRate(new Runnable(){
            private final ExecutorService executor = Executors.newSingleThreadExecutor();
            private Future<?> lastExecution;

            @Override
            public void run() {
                if (this.lastExecution != null && !this.lastExecution.isDone()) {
                    return;
                }
                this.lastExecution = this.executor.submit(sender);
            }
        }, 10L, 30L, TimeUnit.SECONDS);
    }

    private void sendQueue() {
        ArrayList events = new ArrayList(this.eventsQueue.size());
        this.eventsQueue.drainTo(events);
        if (!events.isEmpty()) {
            this.restClient.postEvents(events);
        }
    }

    @Override
    public boolean queueEvent(Event event) {
        return this.eventsQueue.offer(event);
    }

    @Override
    public void close() throws IOException {
        this.sendQueue();
    }

    class Sender
    implements Runnable {
        Sender() {
        }

        @Override
        public void run() {
            EventsClientImpl.this.sendQueue();
        }
    }
}

