/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client.core;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.featureflow.client.FeatureControlCallbackHandler;
import io.featureflow.client.FeatureflowConfig;
import io.featureflow.client.core.CallbackEvent;
import io.featureflow.client.core.EventSource;
import io.featureflow.client.core.EventSourceHandler;
import io.featureflow.client.core.EventSourceMessage;
import io.featureflow.client.core.FeatureControlCache;
import io.featureflow.client.core.NoOpFuture;
import io.featureflow.client.model.FeatureControl;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureControlStreamClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(FeatureControlStreamClient.class);
    public static final String FEATURES_UPDATED = "features.updated";
    public static final String FEATURES_DELETED = "features.deleted";
    private final FeatureflowConfig config;
    private final FeatureControlCache repository;
    private final Map<CallbackEvent, List<FeatureControlCallbackHandler>> callbacks;
    private EventSource eventSource;
    Type mapOfFeatureControlsType = new TypeToken<Map<String, FeatureControl>>(){}.getType();
    Type listOfStringType = new TypeToken<List<String>>(){}.getType();
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private String apiKey;

    public FeatureControlStreamClient(String apiKey, FeatureflowConfig config, FeatureControlCache repository, Map<CallbackEvent, List<FeatureControlCallbackHandler>> callbacks) {
        this.apiKey = apiKey;
        this.config = config;
        this.repository = repository;
        this.callbacks = callbacks;
    }

    public Future<Void> start() {
        NoOpFuture initFuture = new NoOpFuture();
        Headers headers = new Headers.Builder().add("Authorization", "Bearer " + this.apiKey).add("User-Agent", "FeatureflowClient-Java/1.0").add("Cache-Control", "no-cache").add("Accept", "text/event-stream").build();
        URI path = URI.create(this.config.getStreamBaseUri() + "/api/sdk/v1/features");
        this.eventSource = new EventSource(path, 5000L, headers, this.getHandler(initFuture));
        this.eventSource.init();
        return initFuture;
    }

    private EventSourceHandler getHandler(final NoOpFuture initFuture) {
        EventSourceHandler handler = new EventSourceHandler(){

            @Override
            public void onConnect() throws Exception {
                logger.info("Featureflow Connected");
            }

            @Override
            public void onMessage(String name, EventSourceMessage event) throws Exception {
                Gson gson = new Gson();
                if (event.getData().startsWith("{\"heartbeat\"")) {
                    if (!FeatureControlStreamClient.this.initialized.getAndSet(true)) {
                        initFuture.completed(null);
                        logger.info("Featureflow client initialised.");
                    }
                    return;
                }
                if (FeatureControlStreamClient.FEATURES_DELETED.equals(name)) {
                    List featureKeys = (List)gson.fromJson(event.getData(), FeatureControlStreamClient.this.listOfStringType);
                    for (String string : featureKeys) {
                        FeatureControl deletedControl = FeatureControlStreamClient.this.repository.get(string);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Received Message to delete feature {}.", (Object)string);
                        }
                        FeatureControlStreamClient.this.repository.delete(string);
                        if (FeatureControlStreamClient.this.callbacks == null || FeatureControlStreamClient.this.callbacks.get((Object)CallbackEvent.DELETED_FEATURE) == null) continue;
                        for (FeatureControlCallbackHandler callback : (List)FeatureControlStreamClient.this.callbacks.get((Object)CallbackEvent.DELETED_FEATURE)) {
                            callback.onUpdate(deletedControl);
                        }
                    }
                }
                if (FeatureControlStreamClient.FEATURES_UPDATED.equals(name)) {
                    Map controls = (Map)gson.fromJson(event.getData(), FeatureControlStreamClient.this.mapOfFeatureControlsType);
                    for (Map.Entry entry : controls.entrySet()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Received Message to update feature {} enabled: {}.", entry.getKey(), (Object)((FeatureControl)entry.getValue()).enabled);
                        }
                        FeatureControlStreamClient.this.repository.update((String)entry.getKey(), (FeatureControl)entry.getValue());
                        if (FeatureControlStreamClient.this.callbacks == null || FeatureControlStreamClient.this.callbacks.get((Object)CallbackEvent.UPDATED_FEATURE) == null) continue;
                        for (FeatureControlCallbackHandler callback : (List)FeatureControlStreamClient.this.callbacks.get((Object)CallbackEvent.UPDATED_FEATURE)) {
                            callback.onUpdate((FeatureControl)entry.getValue());
                        }
                    }
                }
                if (!FeatureControlStreamClient.this.initialized.getAndSet(true)) {
                    initFuture.completed(null);
                    logger.info("Featureflow client initialised.");
                }
            }

            @Override
            public void onError(Throwable throwable) {
                logger.warn("Error", throwable);
            }
        };
        return handler;
    }

    @Override
    public void close() throws IOException {
        if (this.eventSource != null) {
            this.eventSource.close();
        }
        if (this.repository != null) {
            this.repository.close();
        }
    }

    public boolean initialized() {
        return this.initialized.get();
    }
}

