/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client.model;

import io.featureflow.client.FeatureflowUser;
import io.featureflow.client.model.Audience;
import io.featureflow.client.model.VariantSplit;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public class Rule {
    public static final String ANONYMOUS = "anonymous";
    private Audience audience;
    private List<VariantSplit> variantSplits;

    public void setAudience(Audience audience) {
        this.audience = audience;
    }

    public Audience getAudience() {
        return this.audience;
    }

    public List<VariantSplit> getVariantSplits() {
        return this.variantSplits;
    }

    public void setVariantSplits(List<VariantSplit> variantSplits) {
        this.variantSplits = variantSplits;
    }

    public boolean matches(FeatureflowUser user) {
        return this.audience == null || this.audience.matches(user);
    }

    public String getVariantSplitKey(String userId, String featureKey, String salt) {
        if (userId == null) {
            userId = ANONYMOUS;
        }
        long variantValue = this.getVariantValue(this.getHash(userId, featureKey, salt));
        return this.getSplitKey(variantValue);
    }

    public String getSplitKey(long variantValue) {
        int percent = 0;
        for (VariantSplit variantSplit : this.variantSplits) {
            if ((long)(percent = (int)((long)percent + variantSplit.getSplit())) < variantValue) continue;
            return variantSplit.getVariantKey();
        }
        return null;
    }

    public String getHash(String userId, String featureKey, String salt) {
        String hash = DigestUtils.sha1Hex((String)(salt + ":" + featureKey + ":" + userId)).substring(0, 15);
        return hash;
    }

    public long getVariantValue(String hash) {
        long longVal = Long.parseLong(hash, 16);
        return longVal % 100L + 1L;
    }
}

