/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import org.apache.http.HttpHost;

public class FeatureflowConfig {
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 20000;
    private static final String DEFAULT_STREAM_BASE_URI = "https://rtm.featureflow.io";
    private static final String DEFAULT_SDK_BASE_URL = "https://app.featureflow.io";
    private static final String DEFAULT_EVENTS_BASE_URI = "https://events.featureflow.io";
    public static final String VERSION = "1.0.4";
    private boolean offline;
    private String proxyHost;
    private String proxyScheme;
    private int proxyPort;
    private int connectTimeout;
    private int socketTimeout;
    private String sdkBaseUri;
    private String eventsBaseUri;
    private String streamBaseUri;
    public long waitForStartup = 10000L;

    FeatureflowConfig(String proxyHost, String proxyScheme, int proxyPort, int connectTimeout, int socketTimeout, String sdkBaseUri, String streamBaseUri, String eventsBaseUri, long waitForStartup, boolean offline) {
        this.proxyHost = proxyHost;
        this.proxyScheme = proxyScheme;
        this.proxyPort = proxyPort;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.sdkBaseUri = sdkBaseUri;
        this.streamBaseUri = streamBaseUri;
        this.eventsBaseUri = eventsBaseUri;
        this.waitForStartup = waitForStartup;
        this.offline = offline;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HttpHost getHttpProxyHost() {
        if (this.proxyHost == null && this.proxyPort == -1 && this.proxyScheme == null) {
            return null;
        }
        String hostname = this.proxyHost == null ? "localhost" : this.proxyHost;
        String scheme = this.proxyScheme == null ? "https" : this.proxyScheme;
        return new HttpHost(hostname, this.proxyPort, scheme);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public String getSdkBaseUri() {
        return this.sdkBaseUri;
    }

    public String getEventBaseUri() {
        return this.eventsBaseUri;
    }

    public String getStreamBaseUri() {
        return this.streamBaseUri;
    }

    public long getWaitForStartup() {
        return this.waitForStartup;
    }

    public static class Builder {
        private String proxyHost = null;
        private String proxyScheme = null;
        private int proxyPort = -1;
        private int connectTimeout = 30000;
        private int socketTimeout = 20000;
        private String sdkBaseURI = "https://app.featureflow.io";
        private String streamBaseUri = "https://rtm.featureflow.io";
        private String eventsBaseUri = "https://events.featureflow.io";
        long waitForStartup = 10000L;
        boolean offline = false;

        public Builder withProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder withProxyScheme(String proxyScheme) {
            this.proxyScheme = proxyScheme;
            return this;
        }

        public Builder withProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        @Deprecated
        public Builder withBaseUri(String baseUri) {
            this.sdkBaseURI = baseUri;
            return this;
        }

        public Builder withSdkBaseUri(String sdkBaseURI) {
            this.sdkBaseURI = sdkBaseURI;
            return this;
        }

        public Builder withStreamBaseUri(String streamBaseUri) {
            this.streamBaseUri = streamBaseUri;
            return this;
        }

        public Builder withEventsBaseUri(String eventsBaseUri) {
            this.eventsBaseUri = eventsBaseUri;
            return this;
        }

        public Builder withWaitForStartup(long waitTimeMilliseconds) {
            this.waitForStartup = waitTimeMilliseconds;
            return this;
        }

        public Builder withOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public FeatureflowConfig build() {
            return new FeatureflowConfig(this.proxyHost, this.proxyScheme, this.proxyPort, this.connectTimeout, this.socketTimeout, this.sdkBaseURI, this.streamBaseUri, this.eventsBaseUri, this.waitForStartup, this.offline);
        }
    }

    public class Event {
        public int queueSize = 10000;
    }
}

