/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import io.featureflow.client.FeatureflowConfig;
import io.featureflow.client.core.RestClient;
import io.featureflow.client.model.Event;
import io.featureflow.client.model.Feature;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientImpl
implements RestClient {
    private static final String APPLICATION_JSON = "application/json";
    private static final String UTF_8 = "UTF-8";
    private final String apiKey;
    private final FeatureflowConfig config;
    private CloseableHttpClient client = null;
    private Gson gson = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

        public JsonElement serialize(DateTime json, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(ISODateTimeFormat.dateTime().print((ReadableInstant)json));
        }
    }).create();
    private static final Logger logger = LoggerFactory.getLogger(RestClientImpl.class);

    public RestClientImpl(String apiKey, FeatureflowConfig config) {
        this.apiKey = apiKey;
        this.config = config;
        this.client = this.createHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFeatureControls(List<Feature> featureRegistrations) throws IOException {
        logger.info("Registering features with featureflow");
        HttpCacheContext context = HttpCacheContext.create();
        HttpPut request = this.putFeaturesRequest(this.apiKey, this.gson.toJson(featureRegistrations));
        CloseableHttpResponse response = null;
        try {
            logger.debug("Putting: " + request);
            response = this.client.execute((HttpUriRequest)request, (HttpContext)context);
            if (response.getStatusLine().getStatusCode() != 200) {
                logger.error("Problem registering controls: " + response.getStatusLine());
                throw new IOException("Problem registering controls " + response.getStatusLine());
            }
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postEvents(List<? extends Event> events) {
        CloseableHttpResponse response = null;
        Type type = new TypeToken<List<Event>>(){}.getType();
        String json = this.gson.toJson(events, type);
        HttpPost request = this.postRequest(this.apiKey, "/api/sdk/v1/events", json);
        StringEntity entity = new StringEntity(json, UTF_8);
        entity.setContentType(APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        try {
            this.client = this.createHttpClient();
            response = this.client.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            logger.error("Network exception posting events", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("Cannot close stream", (Throwable)e);
            }
        }
    }

    private HttpPut putFeaturesRequest(String apiKey, String data) {
        URI path = URI.create(this.config.getSdkBaseUri() + "/api/sdk/v1/register");
        try {
            HttpPut request = new HttpPut(path);
            this.setRequestVals((HttpEntityEnclosingRequestBase)request, data);
            return request;
        }
        catch (Exception e) {
            logger.error("Problem in PUT request ", (Throwable)e);
            return null;
        }
    }

    private HttpPost postRequest(String apiKey, String path, String data) {
        URI base = URI.create(this.config.getEventBaseUri());
        try {
            URI uri = new URIBuilder().setScheme(base.getScheme()).setHost(base.getHost()).setPort(base.getPort()).setPath(path).build();
            HttpPost request = new HttpPost(uri);
            this.setRequestVals((HttpEntityEnclosingRequestBase)request, data);
            return request;
        }
        catch (Exception e) {
            logger.error("Problem in POST request ", (Throwable)e);
            return null;
        }
    }

    private void setRequestVals(HttpEntityEnclosingRequestBase request, String data) {
        StringEntity params = new StringEntity(data, UTF_8);
        params.setContentType(APPLICATION_JSON);
        request.addHeader("content-type", APPLICATION_JSON);
        request.addHeader("Accept", "*/*");
        request.addHeader("Accept-Encoding", "gzip,deflate,sdch");
        request.addHeader("Accept-Language", "en-US,en;q=0.8");
        request.setEntity((HttpEntity)params);
        request.addHeader("Authorization", "Bearer " + this.apiKey);
        request.addHeader("X-Featureflow-Client", "JavaClient/1.1.3");
    }

    private CloseableHttpClient createHttpClient() {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(100);
        manager.setDefaultMaxPerRoute(20);
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).setSharedCache(false).build();
        ServiceUnavailableRetryStrategy unavailableRetryStrategy = new ServiceUnavailableRetryStrategy(){

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                int statusCode = response.getStatusLine().getStatusCode();
                return statusCode == 502 && executionCount < 1000;
            }

            public long getRetryInterval() {
                return 5000L;
            }
        };
        HttpRequestRetryHandler myRetryHandler = (exception, executionCount, context) -> {
            boolean idempotent;
            if (executionCount >= 5) {
                return false;
            }
            if (exception instanceof ConnectTimeoutException) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return false;
            }
            if (exception instanceof UnknownHostException) {
                return false;
            }
            if (exception instanceof SSLException) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpRequest request = clientContext.getRequest();
            boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
            return idempotent;
        };
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.config.getConnectTimeout()).setSocketTimeout(this.config.getSocketTimeout()).setProxy(this.config.getHttpProxyHost()).build();
        CloseableHttpClient client = CachingHttpClients.custom().setCacheConfig(cacheConfig).setConnectionManager((HttpClientConnectionManager)manager).setDefaultRequestConfig(requestConfig).setRetryHandler(myRetryHandler).setServiceUnavailableRetryStrategy(unavailableRetryStrategy).build();
        return client;
    }
}

