/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class FeatureflowUser {
    public static final String ANONYMOUS = "anonymous";
    private String id;
    private String bucketKey = null;
    private boolean saveUser = true;
    private Map<String, JsonElement> attributes = new HashMap<String, JsonElement>();
    private Map<String, JsonElement> sessionAttributes = new HashMap<String, JsonElement>();
    public static final String FEATUREFLOW_USER_ID = "featureflow.user.id";
    public static final String FEATUREFLOW_DATE = "featureflow.date";
    public static final String FEATUREFLOW_HOUROFDAY = "featureflow.hourofday";

    public FeatureflowUser() {
        this.id = ANONYMOUS;
        this.bucketKey = null;
        this.saveUser = false;
    }

    public FeatureflowUser(String id) {
        this.id = id;
    }

    public FeatureflowUser withBucketKey(String bucketKey) {
        this.bucketKey = bucketKey;
        return this;
    }

    public FeatureflowUser saveUser(boolean save) {
        this.saveUser = save;
        return this;
    }

    public FeatureflowUser setAttributes(Map<String, JsonElement> attributes) {
        this.attributes = attributes;
        return this;
    }

    public FeatureflowUser setSessionAttributes(Map<String, JsonElement> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
        return this;
    }

    public FeatureflowUser withAttribute(String key, String value) {
        if (value == null) {
            return this;
        }
        JsonPrimitive jsonValue = new JsonPrimitive(value);
        this.attributes.put(key, (JsonElement)jsonValue);
        return this;
    }

    public FeatureflowUser withAttribute(String key, boolean value) {
        JsonPrimitive jsonValue = new JsonPrimitive(Boolean.valueOf(value));
        this.attributes.put(key, (JsonElement)jsonValue);
        return this;
    }

    public FeatureflowUser withAttribute(String key, DateTime value) {
        if (value == null) {
            return this;
        }
        JsonPrimitive jsonValue = new JsonPrimitive(FeatureflowUser.toIso(value));
        this.attributes.put(key, (JsonElement)jsonValue);
        return this;
    }

    public FeatureflowUser withAttribute(String key, Number value) {
        if (value == null) {
            return this;
        }
        JsonPrimitive jsonValue = new JsonPrimitive(value);
        this.attributes.put(key, (JsonElement)jsonValue);
        return this;
    }

    public FeatureflowUser withDateAttributes(String key, List<DateTime> values) {
        if (values == null) {
            return this;
        }
        JsonArray vals = new JsonArray();
        for (DateTime value : values) {
            if (value == null) continue;
            vals.add((JsonElement)new JsonPrimitive(FeatureflowUser.toIso(value)));
        }
        this.attributes.put(key, (JsonElement)vals);
        return this;
    }

    public FeatureflowUser withNumberAttributes(String key, List<Number> values) {
        if (values == null) {
            return this;
        }
        JsonArray vals = new JsonArray();
        for (Number value : values) {
            if (value == null) continue;
            vals.add((JsonElement)new JsonPrimitive(value));
        }
        this.attributes.put(key, (JsonElement)vals);
        return this;
    }

    public FeatureflowUser withStringAttributes(String key, List<String> values) {
        if (values == null) {
            return this;
        }
        JsonArray vals = new JsonArray();
        for (String value : values) {
            if (value == null) continue;
            vals.add((JsonElement)new JsonPrimitive(value));
        }
        this.attributes.put(key, (JsonElement)vals);
        return this;
    }

    public FeatureflowUser withAttributes(Map<String, JsonElement> values) {
        if (values == null) {
            return this;
        }
        this.attributes.putAll(values);
        return this;
    }

    public FeatureflowUser withSessionAttribute(String key, String value) {
        JsonPrimitive jsonValue = new JsonPrimitive(value);
        this.sessionAttributes.put(key, (JsonElement)jsonValue);
        return this;
    }

    public FeatureflowUser withSessionAttribute(String key, DateTime value) {
        JsonPrimitive jsonValue = new JsonPrimitive(FeatureflowUser.toIso(value));
        this.sessionAttributes.put(key, (JsonElement)jsonValue);
        return this;
    }

    public FeatureflowUser withSessionAttribute(String key, Number value) {
        JsonPrimitive jsonValue = new JsonPrimitive(value);
        this.sessionAttributes.put(key, (JsonElement)jsonValue);
        return this;
    }

    public FeatureflowUser withSessionDateAttributes(String key, List<DateTime> values) {
        JsonArray vals = new JsonArray();
        for (DateTime value : values) {
            vals.add((JsonElement)new JsonPrimitive(FeatureflowUser.toIso(value)));
        }
        this.sessionAttributes.put(key, (JsonElement)vals);
        return this;
    }

    public FeatureflowUser withSessionNumberAttributes(String key, List<Number> values) {
        JsonArray vals = new JsonArray();
        for (Number value : values) {
            vals.add((JsonElement)new JsonPrimitive(value));
        }
        this.sessionAttributes.put(key, (JsonElement)vals);
        return this;
    }

    public FeatureflowUser withSessionStringAttributes(String key, List<String> values) {
        JsonArray vals = new JsonArray();
        for (String value : values) {
            vals.add((JsonElement)new JsonPrimitive(value));
        }
        this.sessionAttributes.put(key, (JsonElement)vals);
        return this;
    }

    public FeatureflowUser withSessionAttributes(Map<String, JsonElement> values) {
        this.sessionAttributes.putAll(values);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getBucketKey() {
        return this.bucketKey;
    }

    public boolean isSaveUser() {
        return this.saveUser;
    }

    public Map<String, JsonElement> getAttributes() {
        return this.attributes;
    }

    public Map<String, JsonElement> getSessionAttributes() {
        return this.sessionAttributes;
    }

    protected static String toIso(DateTime date) {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        String str = fmt.print((ReadableInstant)date);
        return str;
    }

    protected static DateTime fromIso(String isoDate) {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        DateTime dt = fmt.parseDateTime(isoDate);
        return dt;
    }
}

