/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.featureflow.client.EventsClientMock;
import io.featureflow.client.FeatureControlCallbackHandler;
import io.featureflow.client.FeatureflowConfig;
import io.featureflow.client.FeatureflowUser;
import io.featureflow.client.FeatureflowUserLookupProvider;
import io.featureflow.client.FeatureflowUserProvider;
import io.featureflow.client.RestClientMock;
import io.featureflow.client.core.CallbackEvent;
import io.featureflow.client.core.EventsClient;
import io.featureflow.client.core.EventsClientImpl;
import io.featureflow.client.core.FeatureControlCache;
import io.featureflow.client.core.FeatureControlStreamClient;
import io.featureflow.client.core.RestClient;
import io.featureflow.client.core.RestClientImpl;
import io.featureflow.client.core.SimpleMemoryFeatureCache;
import io.featureflow.client.model.Event;
import io.featureflow.client.model.Feature;
import io.featureflow.client.model.FeatureControl;
import java.io.Closeable;
import java.io.IOException;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureflowClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(FeatureflowClient.class);
    private final FeatureflowConfig config;
    private final FeatureControlStreamClient featureControlStreamClient;
    private final FeatureControlCache featureControlCache;
    private final RestClient restClient;
    private final EventsClient eventHandler;
    private final Map<String, Feature> featuresMap = new HashMap<String, Feature>();
    private final FeatureflowUserProvider userProvider;
    private final FeatureflowUserLookupProvider userLookupProvider;
    private final boolean offline;

    FeatureflowClient(String apiKey) {
        this(apiKey, null, new FeatureflowConfig.Builder().build(), null, null, null, false);
    }

    FeatureflowClient(String apiKey, List<Feature> features) {
        this(apiKey, features, new FeatureflowConfig.Builder().build(), null, null, null, false);
    }

    FeatureflowClient(String apiKey, List<Feature> features, FeatureflowConfig config, Map<CallbackEvent, List<FeatureControlCallbackHandler>> callbacks, FeatureflowUserProvider userProvider, FeatureflowUserLookupProvider userLookupProvider, boolean offline) {
        this.config = config;
        this.userProvider = userProvider;
        this.userLookupProvider = userLookupProvider;
        this.offline = offline;
        this.featureControlCache = new SimpleMemoryFeatureCache();
        if (offline) {
            this.restClient = new RestClientMock(apiKey, config);
            this.eventHandler = new EventsClientMock(config, this.restClient);
        } else {
            this.restClient = new RestClientImpl(apiKey, config);
            this.eventHandler = new EventsClientImpl(config, this.restClient);
        }
        if (features != null && features.size() > 0) {
            for (Feature feature : features) {
                this.featuresMap.put(feature.key, feature);
            }
            try {
                this.restClient.registerFeatureControls(features);
            }
            catch (IOException e) {
                logger.error("Problem registering feature controls", (Throwable)e);
            }
        }
        if (!offline) {
            this.featureControlStreamClient = new FeatureControlStreamClient(apiKey, config, this.featureControlCache, callbacks);
            Future<Void> startFuture = this.featureControlStreamClient.start();
            if (config.waitForStartup > 0L) {
                logger.info("Waiting for Featureflow to initialise");
                try {
                    startFuture.get(config.waitForStartup, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    logger.error("Timeout waiting for Featureflow client initialise");
                }
                catch (Exception e) {
                    logger.error("Exception waiting for Featureflow client to initialise", (Throwable)e);
                }
            }
        } else {
            logger.info("Featureflow client is running in offline mode, no stream connection will be made.");
            this.featureControlStreamClient = null;
        }
    }

    public Evaluate evaluate(String featureKey, FeatureflowUser user) {
        Evaluate e = new Evaluate(this, featureKey, user);
        return e;
    }

    public Evaluate evaluate(String featureKey, String userId) {
        FeatureflowUser user = this.userLookupProvider == null ? new FeatureflowUser(userId) : this.userLookupProvider.getUser(userId);
        Evaluate e = new Evaluate(this, featureKey, user);
        return e;
    }

    public Evaluate evaluate(String featureKey) {
        FeatureflowUser user = this.userProvider == null ? new FeatureflowUser() : this.userProvider.getUser();
        return this.evaluate(featureKey, user);
    }

    public Map<String, String> evaluateAll(FeatureflowUser user) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : this.featureControlCache.getAll().keySet()) {
            result.put(s, this.eval(s, user));
        }
        return result;
    }

    private String eval(String featureKey, FeatureflowUser user) {
        String failoverVariant = this.featuresMap.get(featureKey) != null && this.featuresMap.get((Object)featureKey).failoverVariant != null ? this.featuresMap.get((Object)featureKey).failoverVariant : "off";
        FeatureControl control = this.featureControlCache.get(featureKey);
        if (!this.offline && !this.featureControlStreamClient.initialized()) {
            logger.warn("FeatureFlow is not initialized yet.");
        }
        if (control == null) {
            logger.warn("Feature '" + featureKey + " 'does not exist, returning failover variant of " + failoverVariant);
            return failoverVariant;
        }
        this.addAdditionalAttributes(user);
        String variant = control.evaluate(user);
        return variant;
    }

    private void addAdditionalAttributes(FeatureflowUser user) {
        user.getAttributes().put("featureflow.user.id", (JsonElement)new JsonPrimitive(user.getId()));
        user.getSessionAttributes().put("featureflow.hourofday", (JsonElement)new JsonPrimitive((Number)LocalTime.now().getHour()));
        user.getSessionAttributes().put("featureflow.date", (JsonElement)new JsonPrimitive(FeatureflowUser.toIso(new DateTime())));
    }

    @Override
    public void close() throws IOException {
        this.eventHandler.close();
    }

    public static Builder builder(String apiKey) {
        return new Builder(apiKey);
    }

    public void track(String goalKey, FeatureflowUser user) {
        this.eventHandler.queueEvent(new Event(goalKey, user, this.evaluateAll(user)));
    }

    public class Evaluate {
        private final String evaluateResult;
        private final String featureKey;
        private final FeatureflowUser user;
        private final FeatureflowClient client;

        Evaluate(FeatureflowClient featureflowClient, String featureKey, FeatureflowUser user) {
            this.featureKey = featureKey;
            this.user = user;
            this.evaluateResult = featureflowClient.eval(featureKey, user);
            this.client = featureflowClient;
        }

        Evaluate(FeatureflowClient featureflowClient, String featureKey, String userId) {
            this.featureKey = featureKey;
            this.user = FeatureflowClient.this.userProvider != null ? FeatureflowClient.this.userProvider.getUser() : (FeatureflowClient.this.userLookupProvider != null && userId != null ? FeatureflowClient.this.userLookupProvider.getUser(userId) : new FeatureflowUser(userId));
            this.client = featureflowClient;
            this.evaluateResult = featureflowClient.eval(featureKey, this.user);
        }

        public boolean isOn() {
            return this.is("on");
        }

        public boolean isOff() {
            return this.is("off");
        }

        public boolean is(String variant) {
            if (!this.client.offline) {
                FeatureflowClient.this.eventHandler.queueEvent(new Event(this.featureKey, "evaluate", this.user, this.evaluateResult, variant));
            }
            return variant.equals(this.evaluateResult);
        }

        public String value() {
            if (!this.client.offline) {
                FeatureflowClient.this.eventHandler.queueEvent(new Event(this.featureKey, "evaluate", this.user, this.evaluateResult, null));
            }
            return this.evaluateResult;
        }
    }

    public static class Builder {
        private FeatureflowConfig config = null;
        private String apiKey;
        private Map<CallbackEvent, List<FeatureControlCallbackHandler>> featureControlCallbackHandlers = new HashMap<CallbackEvent, List<FeatureControlCallbackHandler>>();
        private FeatureflowUserProvider userProvider;
        private FeatureflowUserLookupProvider userLookupProvider;
        private List<Feature> features = new ArrayList<Feature>();
        private boolean offline = false;

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder withOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder withUpdateCallback(FeatureControlCallbackHandler featureControlCallbackHandler) {
            this.withCallback(CallbackEvent.UPDATED_FEATURE, featureControlCallbackHandler);
            return this;
        }

        public Builder withDeleteCallback(FeatureControlCallbackHandler featureControlCallbackHandler) {
            this.withCallback(CallbackEvent.DELETED_FEATURE, featureControlCallbackHandler);
            return this;
        }

        public Builder withCallback(CallbackEvent event, FeatureControlCallbackHandler featureControlCallbackHandler) {
            if (this.featureControlCallbackHandlers.get((Object)event) == null) {
                this.featureControlCallbackHandlers.put(event, new ArrayList());
            }
            this.featureControlCallbackHandlers.get((Object)event).add(featureControlCallbackHandler);
            return this;
        }

        public Builder withUserProvider(FeatureflowUserProvider userProvider) {
            this.userProvider = userProvider;
            return this;
        }

        public Builder withUserLookupProvider(FeatureflowUserLookupProvider userLookupProvider) {
            this.userLookupProvider = userLookupProvider;
            return this;
        }

        public Builder withConfig(FeatureflowConfig config) {
            this.config = config;
            return this;
        }

        public Builder withFeature(Feature feature) {
            this.features.add(feature);
            return this;
        }

        public Builder withFeatures(List<Feature> features) {
            this.features = features;
            return this;
        }

        public FeatureflowClient build() {
            if (this.config == null) {
                this.config = new FeatureflowConfig.Builder().build();
            }
            return new FeatureflowClient(this.apiKey, this.features, this.config, this.featureControlCallbackHandlers, this.userProvider, this.userLookupProvider, this.offline);
        }
    }
}

