/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client.core;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.featureflow.client.FeatureControlCallbackHandler;
import io.featureflow.client.FeatureflowConfig;
import io.featureflow.client.core.CallbackEvent;
import io.featureflow.client.core.EventSource;
import io.featureflow.client.core.EventSourceHandler;
import io.featureflow.client.core.EventSourceMessage;
import io.featureflow.client.core.FeatureControlCache;
import io.featureflow.client.core.NoOpFuture;
import io.featureflow.client.model.FeatureControl;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureControlStreamClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(FeatureControlStreamClient.class);
    public static final String FEATURES_UPDATED = "features.updated";
    public static final String FEATURES_DELETED = "features.deleted";
    private final FeatureflowConfig config;
    private final FeatureControlCache repository;
    private final Map<CallbackEvent, List<FeatureControlCallbackHandler>> callbacks;
    private EventSource eventSource;
    Type mapOfFeatureControlsType = new TypeToken<Map<String, FeatureControl>>(){}.getType();
    Type listOfStringType = new TypeToken<List<String>>(){}.getType();
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private String apiKey;

    public FeatureControlStreamClient(String apiKey, FeatureflowConfig config, FeatureControlCache repository, Map<CallbackEvent, List<FeatureControlCallbackHandler>> callbacks) {
        this.apiKey = apiKey;
        this.config = config;
        this.repository = repository;
        this.callbacks = callbacks;
    }

    public Future<Void> start() {
        NoOpFuture initFuture = new NoOpFuture();
        Headers headers = new Headers.Builder().add("Authorization", "Bearer " + this.apiKey).add("User-Agent", "FeatureflowClient-Java/1.0").add("Cache-Control", "no-cache").add("Accept", "text/event-stream").build();
        URI path = URI.create(this.config.getStreamUri());
        this.eventSource = new EventSource(path, 5000L, headers, this.getHandler(initFuture));
        this.eventSource.init();
        return initFuture;
    }

    private EventSourceHandler getHandler(final NoOpFuture initFuture) {
        EventSourceHandler handler = new EventSourceHandler(){
            final /* synthetic */ FeatureControlStreamClient this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onConnect() throws Exception {
                logger.info("Featureflow Connected");
            }

            @Override
            public void onMessage(String name, EventSourceMessage event) throws Exception {
                Gson gson = new Gson();
                if (event.getData().startsWith("{\"heartbeat\"")) {
                    if (!this.this$0.initialized.getAndSet(true)) {
                        initFuture.completed(null);
                        logger.info("Featureflow client initialised.");
                    }
                    return;
                }
                if (FeatureControlStreamClient.FEATURES_DELETED.equals(name)) {
                    List featureKeys = (List)gson.fromJson(event.getData(), this.this$0.listOfStringType);
                    for (String string : featureKeys) {
                        FeatureControl deletedControl = this.this$0.repository.get(string);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Received Message to delete feature {}.", (Object)string);
                        }
                        this.this$0.repository.delete(string);
                        if (this.this$0.callbacks == null || this.this$0.callbacks.get((Object)CallbackEvent.DELETED_FEATURE) == null) continue;
                        for (FeatureControlCallbackHandler callback : this.this$0.callbacks.get((Object)CallbackEvent.DELETED_FEATURE)) {
                            callback.onUpdate(deletedControl);
                        }
                    }
                }
                if (FeatureControlStreamClient.FEATURES_UPDATED.equals(name)) {
                    Map controls = (Map)gson.fromJson(event.getData(), this.this$0.mapOfFeatureControlsType);
                    for (Map.Entry entry : controls.entrySet()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Received Message to update feature {} enabled: {}.", entry.getKey(), (Object)((FeatureControl)entry.getValue()).enabled);
                        }
                        this.this$0.repository.update((String)entry.getKey(), (FeatureControl)entry.getValue());
                        if (this.this$0.callbacks == null || this.this$0.callbacks.get((Object)CallbackEvent.UPDATED_FEATURE) == null) continue;
                        for (FeatureControlCallbackHandler callback : this.this$0.callbacks.get((Object)CallbackEvent.UPDATED_FEATURE)) {
                            callback.onUpdate((FeatureControl)entry.getValue());
                        }
                    }
                }
                if (!this.this$0.initialized.getAndSet(true)) {
                    initFuture.completed(null);
                    logger.info("Featureflow client initialised.");
                }
            }

            @Override
            public void onError(Throwable throwable) {
                logger.warn("Error", throwable);
            }
        };
        return handler;
    }

    @Override
    public void close() throws IOException {
        if (this.eventSource != null) {
            this.eventSource.close();
        }
        if (this.repository != null) {
            this.repository.close();
        }
    }

    public boolean initialized() {
        return this.initialized.get();
    }
}

