/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client.model;

import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Operator {
    equals{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            if (contextValue.equals((Object)targetValues.get(0))) {
                return true;
            }
            if (contextValue.isString() && targetValues.get(0).isString() && contextValue.getAsString().equals(targetValues.get(0).getAsString())) {
                return true;
            }
            if (contextValue.isNumber() && targetValues.get(0).isNumber()) {
                return contextValue.getAsDouble() == targetValues.get(0).getAsDouble();
            }
            return false;
        }
    }
    ,
    testRuleEquals{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            return contextValue.isNumber() && targetValues.get(0).isNumber() && contextValue.getAsDouble() > targetValues.get(0).getAsDouble();
        }
    }
    ,
    lessThan{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            return contextValue.isNumber() && targetValues.get(0).isNumber() && contextValue.getAsDouble() < targetValues.get(0).getAsDouble();
        }
    }
    ,
    greaterThan{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            return contextValue.isNumber() && targetValues.get(0).isNumber() && contextValue.getAsDouble() > targetValues.get(0).getAsDouble();
        }
    }
    ,
    greaterThanOrEqual{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            return contextValue.isNumber() && targetValues.get(0).isNumber() && contextValue.getAsDouble() >= targetValues.get(0).getAsDouble();
        }
    }
    ,
    lessThanOrEqual{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            return contextValue.isNumber() && targetValues.get(0).isNumber() && contextValue.getAsDouble() <= targetValues.get(0).getAsDouble();
        }
    }
    ,
    startsWith{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            return contextValue.isString() && targetValues.get(0).isString() && contextValue.getAsString().startsWith(targetValues.get(0).getAsString());
        }
    }
    ,
    endsWith{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            return contextValue.isString() && targetValues.get(0).isString() && contextValue.getAsString().endsWith(targetValues.get(0).getAsString());
        }
    }
    ,
    matches{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            return targetValues.get(0).isString() && contextValue.isString() && Pattern.matches(targetValues.get(0).getAsString(), contextValue.getAsString());
        }
    }
    ,
    in{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            if (targetValues == null) {
                return false;
            }
            for (JsonPrimitive targetValue : targetValues) {
                if (contextValue.equals((Object)targetValue)) {
                    return true;
                }
                if (contextValue.isString() && targetValue.isString() && contextValue.getAsString().equals(targetValue.getAsString())) {
                    return true;
                }
                if (!contextValue.isNumber() || !targetValue.isNumber() || contextValue.getAsDouble() != targetValue.getAsDouble()) continue;
                return true;
            }
            return false;
        }
    }
    ,
    notIn{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            if (targetValues == null) {
                return true;
            }
            for (JsonPrimitive targetValue : targetValues) {
                if (contextValue.equals((Object)targetValue)) {
                    return false;
                }
                if (contextValue.isString() && targetValue.isString() && contextValue.getAsString().equals(targetValue.getAsString())) {
                    return false;
                }
                if (!contextValue.isNumber() || !targetValue.isNumber() || contextValue.getAsDouble() != targetValue.getAsDouble()) continue;
                return false;
            }
            return true;
        }
    }
    ,
    contains{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            return contextValue.isString() && targetValues.get(0).isString() && contextValue.getAsString().contains(targetValues.get(0).getAsString());
        }
    }
    ,
    before{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            DateTime cDateTime;
            DateTime contextDateTime = 13.getDateTime(contextValue);
            if (contextDateTime != null && (cDateTime = 13.getDateTime(targetValues.get(0))) != null) {
                return contextDateTime.isBefore((ReadableInstant)cDateTime);
            }
            return false;
        }
    }
    ,
    after{

        @Override
        public boolean evaluate(JsonPrimitive contextValue, List<JsonPrimitive> targetValues) {
            DateTime cDateTime;
            DateTime contextDateTime = 14.getDateTime(contextValue);
            if (contextDateTime != null && (cDateTime = 14.getDateTime(targetValues.get(0))) != null) {
                return contextDateTime.isAfter((ReadableInstant)cDateTime);
            }
            return false;
        }
    };


    public abstract boolean evaluate(JsonPrimitive var1, List<JsonPrimitive> var2);

    protected static DateTime getDateTime(JsonPrimitive date) {
        if (date.isNumber()) {
            long millis = date.getAsLong();
            return new DateTime(millis);
        }
        if (date.isString()) {
            try {
                DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser();
                return parser.parseDateTime(date.getAsString());
            }
            catch (IllegalArgumentException ex) {
                try {
                    return new DateTime((Object)date.getAsString(), DateTimeZone.UTC);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

