/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import org.apache.hc.core5.http.HttpHost;

public class FeatureflowConfig {
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 20000;
    public static final String DEFAULT_FEATURE_EVENT_URI = "https://events.featureflow.io/api/sdk/v1/events";
    public static final String DEFAULT_REGISTER_FEATURE_URI = "https://events.featureflow.io/api/sdk/v1/register";
    private static final String DEFAULT_STREAM_URI = "https://rtm.featureflow.io/api/sdk/v1/features";
    private static final String DEFAULT_POLLING_URI = "https://app.featureflow.io/api/sdk/v1/features";
    public static final String VERSION = "1.2.0";
    private boolean offline;
    private String proxyHost;
    private String proxyScheme;
    private int proxyPort;
    private int connectTimeout;
    private int socketTimeout;
    private String featureEventUri;
    private String registerFeatureUri;
    private String streamUri;
    private String pollingUri;
    private int pollingInterval;
    private boolean useStreaming;
    public long waitForStartup = 10000L;

    FeatureflowConfig(String proxyHost, String proxyScheme, int proxyPort, int connectTimeout, int socketTimeout, String featureEventUri, String registerFeatureUri, String streamUri, String pollingUri, int pollingInterval, boolean useStreaming, long waitForStartup, boolean offline) {
        this.proxyHost = proxyHost;
        this.proxyScheme = proxyScheme;
        this.proxyPort = proxyPort;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.featureEventUri = featureEventUri;
        this.registerFeatureUri = registerFeatureUri;
        this.streamUri = streamUri;
        this.pollingUri = pollingUri;
        this.pollingInterval = pollingInterval;
        this.useStreaming = useStreaming;
        this.waitForStartup = waitForStartup;
        this.offline = offline;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HttpHost getHttpProxyHost() {
        if (this.proxyHost == null && this.proxyPort == -1 && this.proxyScheme == null) {
            return null;
        }
        String hostname = this.proxyHost == null ? "localhost" : this.proxyHost;
        String scheme = this.proxyScheme == null ? "https" : this.proxyScheme;
        return new HttpHost(scheme, hostname, this.proxyPort);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public String getRegisterFeatureUri() {
        return this.registerFeatureUri;
    }

    public String getFeatureEventUri() {
        return this.featureEventUri;
    }

    public String getStreamUri() {
        return this.streamUri;
    }

    public String getPollingUri() {
        return this.pollingUri;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public boolean isUseStreaming() {
        return this.useStreaming;
    }

    public long getWaitForStartup() {
        return this.waitForStartup;
    }

    public static class Builder {
        private String proxyHost = null;
        private String proxyScheme = null;
        private int proxyPort = -1;
        private int connectTimeout = 30000;
        private int socketTimeout = 20000;
        private String featureEventUri = "https://events.featureflow.io/api/sdk/v1/events";
        private String registerFeatureUri = "https://events.featureflow.io/api/sdk/v1/register";
        private String streamUri = "https://rtm.featureflow.io/api/sdk/v1/features";
        private String pollingUri = "https://app.featureflow.io/api/sdk/v1/features";
        private int pollingInterval = 60000;
        private boolean useStreaming = false;
        long waitForStartup = 10000L;
        boolean offline = false;

        public Builder withProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder withProxyScheme(String proxyScheme) {
            this.proxyScheme = proxyScheme;
            return this;
        }

        public Builder withProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder withFeatureEventUri(String featureEventUri) {
            this.featureEventUri = featureEventUri;
            return this;
        }

        public Builder withRegisterFeatureUri(String registerFeatureUri) {
            this.registerFeatureUri = registerFeatureUri;
            return this;
        }

        public Builder withStreamUri(String streamUri) {
            this.streamUri = streamUri;
            return this;
        }

        public Builder withPollingUri(String pollingUri) {
            this.pollingUri = pollingUri;
            return this;
        }

        public Builder withPollingInterval(int pollingIntervalSeconds) {
            this.pollingInterval = pollingIntervalSeconds * 1000;
            return this;
        }

        public Builder withUseStreaming(boolean useStreaming) {
            this.useStreaming = useStreaming;
            return this;
        }

        public Builder withWaitForStartup(long waitTimeMilliseconds) {
            this.waitForStartup = waitTimeMilliseconds;
            return this;
        }

        public Builder withOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public FeatureflowConfig build() {
            return new FeatureflowConfig(this.proxyHost, this.proxyScheme, this.proxyPort, this.connectTimeout, this.socketTimeout, this.featureEventUri, this.registerFeatureUri, this.streamUri, this.pollingUri, this.pollingInterval, this.useStreaming, this.waitForStartup, this.offline);
        }
    }

    public class Event {
        public int queueSize = 10000;
    }
}

