/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import io.featureflow.client.FeatureflowConfig;
import io.featureflow.client.core.RestClient;
import io.featureflow.client.model.Event;
import io.featureflow.client.model.Feature;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.cache.HttpCacheContext;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CachingHttpClients;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientImpl
implements RestClient {
    private static final String APPLICATION_JSON = "application/json";
    private static final String UTF_8 = "UTF-8";
    private final String apiKey;
    private final FeatureflowConfig config;
    private CloseableHttpClient client = null;
    private Gson gson = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

        public JsonElement serialize(DateTime json, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(ISODateTimeFormat.dateTime().print((ReadableInstant)json));
        }
    }).create();
    private static final Logger logger = LoggerFactory.getLogger(RestClientImpl.class);

    public RestClientImpl(String apiKey, FeatureflowConfig config) {
        this.apiKey = apiKey;
        this.config = config;
        this.client = this.createHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFeatureControls(List<Feature> featureRegistrations) throws IOException {
        logger.info("Registering features with featureflow");
        URI uri = URI.create(this.config.getRegisterFeatureUri());
        HttpCacheContext context = HttpCacheContext.create();
        HttpPut request = this.createPutRequest(uri, this.gson.toJson(featureRegistrations));
        CloseableHttpResponse response = null;
        try {
            logger.debug("Putting: " + String.valueOf(request));
            response = this.client.execute((ClassicHttpRequest)request, (HttpContext)context);
            if (response.getCode() != 200) {
                logger.error("Problem registering controls: " + response.getReasonPhrase());
                throw new IOException("Problem registering controls " + response.getReasonPhrase());
            }
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postEvents(List<? extends Event> events) {
        URI uri = URI.create(this.config.getFeatureEventUri());
        CloseableHttpResponse response = null;
        Type type = new TypeToken<List<Event>>(){}.getType();
        String json = this.gson.toJson(events, type);
        HttpPost request = this.createPostRequest(uri, json);
        StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        try {
            this.client = this.createHttpClient();
            response = this.client.execute((ClassicHttpRequest)request);
        }
        catch (IOException e) {
            logger.error("Network exception posting events", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("Cannot close stream", (Throwable)e);
            }
        }
    }

    private HttpPut createPutRequest(URI uri, String data) {
        try {
            HttpPut request = new HttpPut(uri);
            this.setRequestVals((HttpMessage)request, data);
            return request;
        }
        catch (Exception e) {
            logger.error("Problem in PUT request ", (Throwable)e);
            return null;
        }
    }

    private HttpPost createPostRequest(URI uri, String data) {
        try {
            HttpPost request = new HttpPost(uri);
            this.setRequestVals((HttpMessage)request, data);
            return request;
        }
        catch (Exception e) {
            logger.error("Problem in POST request ", (Throwable)e);
            return null;
        }
    }

    private void setRequestVals(HttpMessage request, String data) {
        if (request instanceof HttpMessage) {
            StringEntity params = new StringEntity(data, ContentType.APPLICATION_JSON);
            request.addHeader("content-type", (Object)APPLICATION_JSON);
            request.addHeader("Accept", (Object)"*/*");
            request.addHeader("Accept-Encoding", (Object)"gzip,deflate,sdch");
            request.addHeader("Accept-Language", (Object)"en-US,en;q=0.8");
            if (request instanceof HttpPut) {
                HttpPut httpPut = (HttpPut)request;
                httpPut.setEntity((HttpEntity)params);
            } else if (request instanceof HttpPost) {
                HttpPost httpPost = (HttpPost)request;
                httpPost.setEntity((HttpEntity)params);
            }
            request.addHeader("Authorization", (Object)("Bearer " + this.apiKey));
            request.addHeader("X-Featureflow-Client", (Object)"JavaClient/1.2.3");
        }
    }

    private CloseableHttpClient createHttpClient() {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(100);
        manager.setDefaultMaxPerRoute(20);
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).setSharedCache(false).build();
        HttpRequestRetryStrategy serviceUnavailableRetryStrategy = new HttpRequestRetryStrategy(){

            public boolean retryRequest(HttpRequest request, IOException exception, int executionCount, HttpContext context) {
                return false;
            }

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                int statusCode = response.getCode();
                return statusCode == 502 && executionCount < 1000;
            }

            public TimeValue getRetryInterval(HttpRequest request, IOException exception, int executionCount, HttpContext context) {
                return TimeValue.of((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }

            public TimeValue getRetryInterval(HttpResponse response, int executionCount, HttpContext context) {
                return TimeValue.of((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
        };
        HttpRequestRetryStrategy myRetryHandler = new HttpRequestRetryStrategy(){

            public boolean retryRequest(HttpRequest request, IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= 5) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return false;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest originalRequest = clientContext.getRequest();
                boolean idempotent = !(originalRequest instanceof BasicClassicHttpRequest);
                return idempotent;
            }

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                return false;
            }

            public TimeValue getRetryInterval(HttpRequest request, IOException exception, int executionCount, HttpContext context) {
                return TimeValue.of((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }

            public TimeValue getRetryInterval(HttpResponse response, int executionCount, HttpContext context) {
                return TimeValue.of((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
        };
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)this.config.getConnectTimeout())).setResponseTimeout(Timeout.ofMilliseconds((long)this.config.getSocketTimeout())).setProxy(this.config.getHttpProxyHost()).build();
        CloseableHttpClient client = CachingHttpClients.custom().setCacheConfig(cacheConfig).setConnectionManager((HttpClientConnectionManager)manager).setDefaultRequestConfig(requestConfig).setRetryStrategy(myRetryHandler).setRetryStrategy(serviceUnavailableRetryStrategy).build();
        return client;
    }
}

