/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client.example;

import io.featureflow.client.FeatureControlCallbackHandler;
import io.featureflow.client.FeatureflowClient;
import io.featureflow.client.FeatureflowConfig;
import io.featureflow.client.FeatureflowUser;
import io.featureflow.client.model.Feature;
import io.featureflow.client.model.FeatureControl;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class PollingClientExample {
    public static void main(String[] args) {
        System.out.println("=== Featureflow Polling Client Demo ===");
        System.out.println("This example will run for 60 seconds to demonstrate polling behavior.");
        System.out.println("Watch for feature update callbacks as the client polls the server...");
        List<Feature> features = Arrays.asList(new Feature("my-first-feature", "red"));
        FeatureflowConfig pollingConfig = FeatureflowConfig.builder().withPollingInterval(20).build();
        FeatureflowClient client = FeatureflowClient.builder("sdk-srv-env-mykey").withConfig(pollingConfig).withUpdateCallback(new FeatureUpdateCallback()).withDeleteCallback(new FeatureDeleteCallback()).withFeatures(features).build();
        FeatureflowUser user = new FeatureflowUser("user123");
        try {
            for (int i = 0; i < 3; ++i) {
                Thread.sleep(20000L);
                System.out.println("\u23f0 Polling cycle " + (i + 1) + " - checking for feature updates...");
                String currentVariant = client.evaluate("my-first-feature", user).value();
                System.out.println("   Current variant for 'my-first-feature': " + currentVariant);
            }
        }
        catch (InterruptedException e) {
            System.out.println("Demo interrupted");
            Thread.currentThread().interrupt();
        }
        try {
            client.close();
        }
        catch (IOException e) {
            System.err.println("Error closing client: " + e.getMessage());
        }
        System.out.println("\n\u2705 Demo completed! Check the output above for feature update callbacks.");
    }

    static class FeatureUpdateCallback
    implements FeatureControlCallbackHandler {
        FeatureUpdateCallback() {
        }

        @Override
        public void onUpdate(FeatureControl control) {
            System.out.println("\ud83d\udd04 Feature Updated: " + control.key + " (enabled: " + control.enabled + ", offVariant: " + control.offVariantKey + ")");
        }
    }

    static class FeatureDeleteCallback
    implements FeatureControlCallbackHandler {
        FeatureDeleteCallback() {
        }

        @Override
        public void onUpdate(FeatureControl control) {
            System.out.println("\ud83d\uddd1\ufe0f Feature Deleted: " + control.key);
        }
    }
}

