/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client.model;

import io.featureflow.client.FeatureflowUser;
import io.featureflow.client.model.Rule;
import java.util.ArrayList;
import java.util.List;

public class FeatureControl {
    public String key;
    public String salt = "1";
    public boolean enabled;
    public boolean deleted;
    public List<Rule> rules = new ArrayList<Rule>();
    public String offVariantKey;
    public boolean inClientApi;

    public String getKey() {
        return this.key;
    }

    public String evaluate(FeatureflowUser user) {
        if (!this.enabled) {
            return this.offVariantKey;
        }
        for (Rule rule : this.rules) {
            if (!rule.matches(user)) continue;
            return rule.getVariantSplitKey(user.getBucketKey() == null ? user.getId() : user.getBucketKey(), this.key, this.salt);
        }
        return null;
    }

    public String toString() {
        return "FeatureControl{\n  key='" + this.key + "'\n  enabled=" + this.enabled + "\n  deleted=" + this.deleted + "\n  rules=" + this.rules.stream().map(r -> "Rule: " + r.getVariantSplits().stream().map(s -> s.getVariantKey() + ":" + s.getSplit() + "% ").reduce("", String::concat) + "\n").reduce("", String::concat) + "\n  offVariantKey=" + this.offVariantKey + "\n  inClientApi=" + this.inClientApi + "\n}";
    }
}

