/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.getstream.core.LookupKind;
import io.getstream.core.StreamReactions;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Token;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.Reaction;
import io.getstream.core.options.Filter;
import io.getstream.core.utils.Auth;
import io.getstream.core.utils.DefaultOptions;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class ReactionsClient {
    private final String secret;
    private final StreamReactions reactions;

    ReactionsClient(String secret, StreamReactions reactions) {
        this.secret = secret;
        this.reactions = reactions;
    }

    public CompletableFuture<Reaction> get(String id) throws StreamException {
        Token token = Auth.buildReactionsToken(this.secret, Auth.TokenAction.READ);
        return this.reactions.get(token, id);
    }

    public CompletableFuture<List<Reaction>> filter(LookupKind lookup, String id) throws StreamException {
        return this.filter(lookup, id, "");
    }

    public CompletableFuture<List<Reaction>> filter(LookupKind lookup, String id, Filter filter) throws StreamException {
        return this.filter(lookup, id, filter, "");
    }

    public CompletableFuture<List<Reaction>> filter(LookupKind lookup, String id, String kind) throws StreamException {
        return this.filter(lookup, id, DefaultOptions.DEFAULT_FILTER, kind);
    }

    public CompletableFuture<List<Reaction>> filter(LookupKind lookup, String id, Filter filter, String kind) throws StreamException {
        Token token = Auth.buildReactionsToken(this.secret, Auth.TokenAction.READ);
        return this.reactions.filter(token, lookup, id, filter, kind);
    }

    public CompletableFuture<Reaction> add(String userID, String kind, String activityID, Iterable<FeedID> targetFeeds) throws StreamException {
        return this.add(userID, kind, activityID, (FeedID[])Iterables.toArray(targetFeeds, FeedID.class));
    }

    public CompletableFuture<Reaction> add(String userID, String kind, String activityID, FeedID ... targetFeeds) throws StreamException {
        Preconditions.checkNotNull((Object)kind, (Object)"Reaction kind can't be null");
        Preconditions.checkArgument((!kind.isEmpty() ? 1 : 0) != 0, (Object)"Reaction kind can't be empty");
        Preconditions.checkNotNull((Object)activityID, (Object)"Reaction activity id can't be null");
        Preconditions.checkArgument((!activityID.isEmpty() ? 1 : 0) != 0, (Object)"Reaction activity id can't be empty");
        return this.add(userID, Reaction.builder().activityID(activityID).kind(kind).build(), targetFeeds);
    }

    public CompletableFuture<Reaction> add(String userID, Reaction reaction, Iterable<FeedID> targetFeeds) throws StreamException {
        return this.add(userID, reaction, (FeedID[])Iterables.toArray(targetFeeds, FeedID.class));
    }

    public CompletableFuture<Reaction> add(String userID, Reaction reaction, FeedID ... targetFeeds) throws StreamException {
        Token token = Auth.buildReactionsToken(this.secret, Auth.TokenAction.WRITE);
        return this.reactions.add(token, userID, reaction, targetFeeds);
    }

    public CompletableFuture<Reaction> addChild(String userID, String kind, String parentID, Iterable<FeedID> targetFeeds) throws StreamException {
        Reaction child = Reaction.builder().kind(kind).parent(parentID).build();
        return this.add(userID, child, targetFeeds);
    }

    public CompletableFuture<Reaction> addChild(String userID, String kind, String parentID, FeedID ... targetFeeds) throws StreamException {
        Reaction child = Reaction.builder().kind(kind).parent(parentID).build();
        return this.add(userID, child, targetFeeds);
    }

    public CompletableFuture<Reaction> addChild(String userID, String parentID, Reaction reaction, Iterable<FeedID> targetFeeds) throws StreamException {
        Reaction child = Reaction.builder().fromReaction(reaction).parent(parentID).build();
        return this.add(userID, child, targetFeeds);
    }

    public CompletableFuture<Reaction> addChild(String userID, String parentID, Reaction reaction, FeedID ... targetFeeds) throws StreamException {
        Reaction child = Reaction.builder().fromReaction(reaction).parent(parentID).build();
        return this.add(userID, child, targetFeeds);
    }

    public CompletableFuture<Void> update(String id, Iterable<FeedID> targetFeeds) throws StreamException {
        return this.update(id, (FeedID[])Iterables.toArray(targetFeeds, FeedID.class));
    }

    public CompletableFuture<Void> update(String id, FeedID ... targetFeeds) throws StreamException {
        Preconditions.checkNotNull((Object)id, (Object)"Reaction id can't be null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Reaction id can't be empty");
        return this.update(Reaction.builder().id(id).build(), targetFeeds);
    }

    public CompletableFuture<Void> update(Reaction reaction, Iterable<FeedID> targetFeeds) throws StreamException {
        return this.update(reaction, (FeedID[])Iterables.toArray(targetFeeds, FeedID.class));
    }

    public CompletableFuture<Void> update(Reaction reaction, FeedID ... targetFeeds) throws StreamException {
        Token token = Auth.buildReactionsToken(this.secret, Auth.TokenAction.WRITE);
        return this.reactions.update(token, reaction, targetFeeds);
    }

    public CompletableFuture<Void> delete(String id) throws StreamException {
        Token token = Auth.buildReactionsToken(this.secret, Auth.TokenAction.DELETE);
        return this.reactions.delete(token, id);
    }
}

