/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.getstream.core.http.Request;
import io.getstream.core.options.RequestOption;
import java.util.List;

public final class Pagination
implements RequestOption {
    private final List<OpEntry> ops = Lists.newArrayList();

    public Pagination limit(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"limit can't be negative");
        this.ops.add(new OpEntry(OpType.LIMIT, value));
        return this;
    }

    public Pagination offset(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"offset can't be negative");
        this.ops.add(new OpEntry(OpType.OFFSET, value));
        return this;
    }

    @Override
    public void apply(Request.Builder builder) {
        for (OpEntry op : this.ops) {
            builder.addQueryParameter(op.type, Integer.toString(op.value));
        }
    }

    private static final class OpEntry {
        String type;
        int value;

        OpEntry(OpType type, int value) {
            this.type = type.toString();
            this.value = value;
        }
    }

    static enum OpType {
        OFFSET("offset"),
        LIMIT("limit");

        private String operator;

        private OpType(String operator) {
            this.operator = operator;
        }

        public String toString() {
            return this.operator;
        }
    }
}

