/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import io.getstream.core.StreamCollections;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Token;
import io.getstream.core.models.CollectionData;
import io.getstream.core.utils.Auth;
import io.getstream.core.utils.Serialization;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public final class CollectionsClient {
    private final String secret;
    private final StreamCollections collections;

    CollectionsClient(String secret, StreamCollections collections) {
        this.secret = secret;
        this.collections = collections;
    }

    public <T> CompletableFuture<T> addCustom(String collection, T item) throws StreamException {
        return this.addCustom(null, collection, item);
    }

    public <T> CompletableFuture<T> addCustom(String userID, String collection, T item) throws StreamException {
        return this.add(userID, collection, Serialization.convert(item, CollectionData.class)).thenApply(data -> Serialization.convert(data, item.getClass()));
    }

    public CompletableFuture<CollectionData> add(String collection, CollectionData item) throws StreamException {
        return this.add(null, collection, item);
    }

    public CompletableFuture<CollectionData> add(String userID, String collection, CollectionData item) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.WRITE);
        return this.collections.add(token, userID, collection, item);
    }

    public <T> CompletableFuture<T> updateCustom(String collection, T item) throws StreamException {
        return this.updateCustom(null, collection, item);
    }

    public <T> CompletableFuture<T> updateCustom(String userID, String collection, T item) throws StreamException {
        return this.update(userID, collection, Serialization.convert(item, CollectionData.class)).thenApply(data -> Serialization.convert(data, item.getClass()));
    }

    public CompletableFuture<CollectionData> update(String collection, CollectionData item) throws StreamException {
        return this.update(null, collection, item);
    }

    public CompletableFuture<CollectionData> update(String userID, String collection, CollectionData item) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.WRITE);
        return this.collections.update(token, userID, collection, item);
    }

    public <T> CompletableFuture<Void> upsertCustom(String collection, Iterable<T> items) throws StreamException {
        CollectionData[] custom = (CollectionData[])Streams.stream(items).map(item -> CollectionData.buildFrom(item)).toArray(CollectionData[]::new);
        return this.upsert(collection, custom);
    }

    public <T> CompletableFuture<Void> upsertCustom(String collection, T ... items) throws StreamException {
        CollectionData[] custom = (CollectionData[])Arrays.stream(items).map(item -> CollectionData.buildFrom(item)).toArray(CollectionData[]::new);
        return this.upsert(collection, custom);
    }

    public CompletableFuture<Void> upsert(String collection, Iterable<CollectionData> items) throws StreamException {
        return this.upsert(collection, (CollectionData[])Iterables.toArray(items, CollectionData.class));
    }

    public CompletableFuture<Void> upsert(String collection, CollectionData ... items) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.WRITE);
        return this.collections.upsert(token, collection, items);
    }

    public <T> CompletableFuture<List<T>> customItems(Class<T> type, String collection) throws StreamException {
        return this.items(collection).thenApply(result -> result.stream().map(item -> Serialization.convert(item, type)).collect(Collectors.toList()));
    }

    public CompletableFuture<List<CollectionData>> items(String collection) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.READ);
        return this.collections.items(token, collection);
    }

    public <T> CompletableFuture<T> getCustom(Class<T> type, String collection, String id) throws StreamException {
        return this.get(collection, id).thenApply(data -> Serialization.convert(data, type));
    }

    public CompletableFuture<CollectionData> get(String collection, String id) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.READ);
        return this.collections.get(token, collection, id);
    }

    public <T> CompletableFuture<List<T>> selectCustom(Class<T> type, String collection, Iterable<String> ids) throws StreamException {
        return this.selectCustom(type, collection, (String[])Iterables.toArray(ids, String.class));
    }

    public <T> CompletableFuture<List<T>> selectCustom(Class<T> type, String collection, String ... ids) throws StreamException {
        return this.select(collection, ids).thenApply(data -> data.stream().map(item -> Serialization.convert(item, type)).collect(Collectors.toList()));
    }

    public CompletableFuture<List<CollectionData>> select(String collection, Iterable<String> ids) throws StreamException {
        return this.select(collection, (String[])Iterables.toArray(ids, String.class));
    }

    public CompletableFuture<List<CollectionData>> select(String collection, String ... ids) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.READ);
        return this.collections.select(token, collection, ids);
    }

    public CompletableFuture<Void> delete(String collection, String id) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.DELETE);
        return this.collections.delete(token, collection, id);
    }

    public CompletableFuture<Void> deleteMany(String collection, Iterable<String> ids) throws StreamException {
        return this.deleteMany(collection, (String[])Iterables.toArray(ids, String.class));
    }

    public CompletableFuture<Void> deleteMany(String collection, String ... ids) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.DELETE);
        return this.collections.deleteMany(token, collection, ids);
    }
}

