/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.cloud;

import io.getstream.core.StreamCollections;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Token;
import io.getstream.core.models.CollectionData;
import io.getstream.core.utils.Serialization;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public final class CloudCollectionsClient {
    private final Token token;
    private final String userID;
    private final StreamCollections collections;

    CloudCollectionsClient(Token token, String userID, StreamCollections collections) {
        this.token = token;
        this.userID = userID;
        this.collections = collections;
    }

    public <T> CompletableFuture<T> addCustom(String collection, T item) throws StreamException {
        return this.addCustom(this.userID, collection, item);
    }

    public <T> CompletableFuture<T> addCustom(String userID, String collection, T item) throws StreamException {
        return this.add(userID, collection, Serialization.convert(item, CollectionData.class)).thenApply(data -> Serialization.convert(data, item.getClass()));
    }

    public CompletableFuture<CollectionData> add(String collection, CollectionData item) throws StreamException {
        return this.add(this.userID, collection, item);
    }

    public CompletableFuture<CollectionData> add(String userID, String collection, CollectionData item) throws StreamException {
        return this.collections.add(this.token, userID, collection, item);
    }

    public <T> CompletableFuture<T> updateCustom(String collection, T item) throws StreamException {
        return this.updateCustom(this.userID, collection, item);
    }

    public <T> CompletableFuture<T> updateCustom(String userID, String collection, T item) throws StreamException {
        return this.update(userID, collection, Serialization.convert(item, CollectionData.class)).thenApply(data -> Serialization.convert(data, item.getClass()));
    }

    public CompletableFuture<CollectionData> update(String collection, CollectionData item) throws StreamException {
        return this.update(this.userID, collection, item);
    }

    public CompletableFuture<CollectionData> update(String userID, String collection, CollectionData item) throws StreamException {
        return this.collections.update(this.token, userID, collection, item);
    }

    public <T> CompletableFuture<List<T>> customItems(Class<T> type, String collection) throws StreamException {
        return this.items(collection).thenApply(result -> result.stream().map(item -> Serialization.convert(item, type)).collect(Collectors.toList()));
    }

    public CompletableFuture<List<CollectionData>> items(String collection) throws StreamException {
        return this.collections.items(this.token, collection);
    }

    public <T> CompletableFuture<T> getCustom(Class<T> type, String collection, String id) throws StreamException {
        return this.get(collection, id).thenApply(data -> Serialization.convert(data, type));
    }

    public CompletableFuture<CollectionData> get(String collection, String id) throws StreamException {
        return this.collections.get(this.token, collection, id);
    }

    public CompletableFuture<Void> delete(String collection, String id) throws StreamException {
        return this.collections.delete(this.token, collection, id);
    }
}

