/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.OptBoolean;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import io.getstream.core.StreamAnalytics;
import io.getstream.core.StreamBatch;
import io.getstream.core.StreamCollections;
import io.getstream.core.StreamFiles;
import io.getstream.core.StreamImages;
import io.getstream.core.StreamPersonalization;
import io.getstream.core.StreamReactions;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.Response;
import io.getstream.core.http.Token;
import io.getstream.core.models.Activity;
import io.getstream.core.models.Data;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.OGData;
import io.getstream.core.options.CustomQueryParameter;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Request;
import io.getstream.core.utils.Routes;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class Stream {
    private final String key;
    private final URL baseURL;
    private final HTTPClient httpClient;

    public Stream(String key, URL baseURL, HTTPClient httpClient) {
        this.key = key;
        this.baseURL = baseURL;
        this.httpClient = httpClient;
    }

    public StreamBatch batch() {
        return new StreamBatch(this.key, this.baseURL, this.httpClient);
    }

    public StreamCollections collections() {
        return new StreamCollections(this.key, this.baseURL, this.httpClient);
    }

    public StreamPersonalization personalization() {
        return new StreamPersonalization(this.key, this.baseURL, this.httpClient);
    }

    public StreamAnalytics analytics() {
        return new StreamAnalytics(this.key, this.baseURL, this.httpClient);
    }

    public StreamReactions reactions() {
        return new StreamReactions(this.key, this.baseURL, this.httpClient);
    }

    public StreamFiles files() {
        return new StreamFiles(this.key, this.baseURL, this.httpClient);
    }

    public StreamImages images() {
        return new StreamImages(this.key, this.baseURL, this.httpClient);
    }

    public CompletableFuture<Activity> updateActivityByID(Token token, String id, Map<String, Object> set, String[] unset) throws StreamException {
        Preconditions.checkNotNull((Object)id, (Object)"No activity to update");
        Preconditions.checkNotNull(set, (Object)"No activity properties to set");
        Preconditions.checkNotNull((Object)unset, (Object)"No activity properties to unset");
        try {
            final String activityID = id;
            final Map<String, Object> propertiesToSet = set;
            final String[] propertiesToUnset = unset;
            byte[] payload = Serialization.toJSON(new Object(){
                public final String id;
                public final Map<String, Object> set;
                public final String[] unset;
                {
                    this.id = activityID;
                    this.set = propertiesToSet;
                    this.unset = propertiesToUnset;
                }
            });
            URL url = Routes.buildActivityUpdateURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserialize(response, Activity.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Activity> updateActivityByForeignID(Token token, final String foreignID, final Date timestamp, Map<String, Object> set, String[] unset) throws StreamException {
        Preconditions.checkNotNull((Object)foreignID, (Object)"No activity to update");
        Preconditions.checkNotNull((Object)timestamp, (Object)"Missing timestamp");
        Preconditions.checkNotNull(set, (Object)"No activity properties to set");
        Preconditions.checkNotNull((Object)unset, (Object)"No activity properties to unset");
        try {
            final Map<String, Object> propertiesToSet = set;
            final String[] propertiesToUnset = unset;
            byte[] payload = Serialization.toJSON(new Object(){
                public final String foreign_id;
                @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS", lenient=OptBoolean.FALSE, timezone="UTC")
                public final Date time;
                public final Map<String, Object> set;
                public final String[] unset;
                {
                    this.foreign_id = foreignID;
                    this.time = timestamp;
                    this.set = propertiesToSet;
                    this.unset = propertiesToUnset;
                }
            });
            URL url = Routes.buildActivityUpdateURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserialize(response, Activity.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<OGData> openGraph(Token token, URL targetURL) throws StreamException {
        Preconditions.checkNotNull((Object)targetURL, (Object)"Missing url");
        try {
            URL url = Routes.buildOpenGraphURL(this.baseURL);
            return this.httpClient.execute(Request.buildGet(url, this.key, token, new CustomQueryParameter("url", targetURL.toExternalForm()))).thenApply(response -> {
                try {
                    return Serialization.deserialize(response, OGData.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public <T> T getHTTPClientImplementation() {
        return this.httpClient.getImplementation();
    }

    public CompletableFuture<Response> getActivities(Token token, FeedID feed, RequestOption ... options) throws StreamException {
        Preconditions.checkNotNull((Object)options, (Object)"Missing request options");
        try {
            URL url = Routes.buildFeedURL(this.baseURL, feed, "/");
            return this.httpClient.execute(Request.buildGet(url, this.key, token, options));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> getEnrichedActivities(Token token, FeedID feed, RequestOption ... options) throws StreamException {
        Preconditions.checkNotNull((Object)options, (Object)"Missing request options");
        try {
            URL url = Routes.buildEnrichedFeedURL(this.baseURL, feed, "/");
            return this.httpClient.execute(Request.buildGet(url, this.key, token, options));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> addActivity(Token token, FeedID feed, Activity activity) throws StreamException {
        Preconditions.checkNotNull((Object)activity, (Object)"No activity to add");
        try {
            byte[] payload = Serialization.toJSON(activity);
            URL url = Routes.buildFeedURL(this.baseURL, feed, "/");
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0]));
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> addActivities(Token token, FeedID feed, final Activity ... activityObjects) throws StreamException {
        Preconditions.checkNotNull((Object)activityObjects, (Object)"No activities to add");
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public final Activity[] activities;
                {
                    this.activities = activityObjects;
                }
            });
            URL url = Routes.buildFeedURL(this.baseURL, feed, "/");
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0]));
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> removeActivityByID(Token token, FeedID feed, String id) throws StreamException {
        Preconditions.checkNotNull((Object)id, (Object)"No activity id to remove");
        try {
            URL url = Routes.buildFeedURL(this.baseURL, feed, '/' + id + '/');
            return this.httpClient.execute(Request.buildDelete(url, this.key, token, new RequestOption[0]));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> removeActivityByForeignID(Token token, FeedID feed, String foreignID) throws StreamException {
        Preconditions.checkNotNull((Object)foreignID, (Object)"No activity id to remove");
        try {
            URL url = Routes.buildFeedURL(this.baseURL, feed, '/' + foreignID + '/');
            return this.httpClient.execute(Request.buildDelete(url, this.key, token, new CustomQueryParameter("foreign_id", "1")));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> follow(Token token, final Token targetToken, FeedID sourceFeed, final FeedID targetFeed, final int activityCopyLimit) throws StreamException {
        Preconditions.checkNotNull((Object)targetFeed, (Object)"No feed to follow");
        Preconditions.checkArgument((sourceFeed != targetFeed ? 1 : 0) != 0, (Object)"Feed can't follow itself");
        Preconditions.checkArgument((activityCopyLimit >= 0 ? 1 : 0) != 0, (Object)"Activity copy limit should be a non-negative number");
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public String target;
                public int activity_copy_limit;
                public String target_token;
                {
                    this.target = targetFeed.toString();
                    this.activity_copy_limit = activityCopyLimit;
                    this.target_token = targetToken.toString();
                }
            });
            URL url = Routes.buildFeedURL(this.baseURL, sourceFeed, "/following/");
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0]));
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> getFollowers(Token token, FeedID feed, RequestOption ... options) throws StreamException {
        Preconditions.checkNotNull((Object)options, (Object)"Missing request options");
        try {
            URL url = Routes.buildFeedURL(this.baseURL, feed, "/followers/");
            return this.httpClient.execute(Request.buildGet(url, this.key, token, options));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> getFollowed(Token token, FeedID feed, RequestOption ... options) throws StreamException {
        Preconditions.checkNotNull((Object)options, (Object)"Missing request options");
        try {
            URL url = Routes.buildFeedURL(this.baseURL, feed, "/following/");
            return this.httpClient.execute(Request.buildGet(url, this.key, token, options));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> unfollow(Token token, FeedID source, FeedID target, RequestOption ... options) throws StreamException {
        Preconditions.checkNotNull((Object)options, (Object)"Missing request options");
        Preconditions.checkNotNull((Object)target, (Object)"No target feed to unfollow");
        try {
            URL url = Routes.buildFeedURL(this.baseURL, source, "/following/" + target + '/');
            return this.httpClient.execute(Request.buildDelete(url, this.key, token, options));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> updateActivityToTargets(Token token, FeedID feed, final Activity activity, FeedID[] add, FeedID[] remove, FeedID[] replace) throws StreamException {
        Preconditions.checkNotNull((Object)activity, (Object)"No activity to update");
        Preconditions.checkNotNull((Object)activity.getForeignID(), (Object)"Activity is required to have foreign ID attribute");
        Preconditions.checkNotNull((Object)activity.getTime(), (Object)"Activity is required to have time attribute");
        Preconditions.checkNotNull((Object)add, (Object)"No targets to add");
        Preconditions.checkNotNull((Object)remove, (Object)"No targets to remove");
        Preconditions.checkNotNull((Object)replace, (Object)"No targets to set");
        boolean modification = replace.length == 0 && (add.length > 0 || remove.length > 0);
        boolean replacement = replace.length > 0 && add.length == 0 && remove.length == 0;
        Preconditions.checkArgument((modification || replacement ? 1 : 0) != 0, (Object)"Can't replace and modify activity to targets at the same time");
        final String[] addedTargets = (String[])Arrays.stream(add).map(id -> id.toString()).toArray(String[]::new);
        final String[] removedTargets = (String[])Arrays.stream(remove).map(id -> id.toString()).toArray(String[]::new);
        final String[] newTargets = (String[])Arrays.stream(replace).map(id -> id.toString()).toArray(String[]::new);
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public String foreign_id;
                @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS", lenient=OptBoolean.FALSE, timezone="UTC")
                public Date time;
                public String[] added_targets;
                public String[] removed_targets;
                public String[] new_targets;
                {
                    this.foreign_id = activity.getForeignID();
                    this.time = activity.getTime();
                    this.added_targets = addedTargets;
                    this.removed_targets = removedTargets;
                    this.new_targets = newTargets;
                }
            });
            URL url = Routes.buildToTargetUpdateURL(this.baseURL, feed);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0]));
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> getUser(Token token, String id, boolean withFollowCounts) throws StreamException {
        Preconditions.checkNotNull((Object)id, (Object)"Missing user ID");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Missing user ID");
        try {
            URL url = Routes.buildUsersURL(this.baseURL, id + '/');
            return this.httpClient.execute(Request.buildGet(url, this.key, token, new CustomQueryParameter("with_follow_counts", Boolean.toString(withFollowCounts))));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> deleteUser(Token token, String id) throws StreamException {
        Preconditions.checkNotNull((Object)id, (Object)"Missing user ID");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Missing user ID");
        try {
            URL url = Routes.buildUsersURL(this.baseURL, id + '/');
            return this.httpClient.execute(Request.buildDelete(url, this.key, token, new RequestOption[0]));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> createUser(Token token, final String userID, final Data userData, boolean getOrCreate) throws StreamException {
        Preconditions.checkNotNull((Object)userID, (Object)"Missing user ID");
        Preconditions.checkNotNull((Object)userData, (Object)"Missing user data");
        Preconditions.checkArgument((!userID.isEmpty() ? 1 : 0) != 0, (Object)"Missing user ID");
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public String id;
                public Map<String, Object> data;
                {
                    this.id = userID;
                    this.data = userData.getData();
                }
            });
            URL url = Routes.buildUsersURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new CustomQueryParameter("get_or_create", Boolean.toString(getOrCreate))));
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Response> updateUser(Token token, String userID, final Data userData) throws StreamException {
        Preconditions.checkNotNull((Object)userID, (Object)"Missing user ID");
        Preconditions.checkNotNull((Object)userData, (Object)"Missing user data");
        Preconditions.checkArgument((!userID.isEmpty() ? 1 : 0) != 0, (Object)"Missing user ID");
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public Map<String, Object> data;
                {
                    this.data = userData.getData();
                }
            });
            URL url = Routes.buildUsersURL(this.baseURL, userID + '/');
            return this.httpClient.execute(Request.buildPut(url, this.key, token, payload, new RequestOption[0]));
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }
}

