/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import com.google.common.collect.Iterables;
import io.getstream.core.StreamAnalytics;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Token;
import io.getstream.core.models.Engagement;
import io.getstream.core.models.Impression;
import io.getstream.core.utils.Auth;
import java.net.URL;
import java8.util.concurrent.CompletableFuture;

public final class AnalyticsClient {
    private final String secret;
    private final StreamAnalytics analytics;

    AnalyticsClient(String secret, StreamAnalytics analytics) {
        this.secret = secret;
        this.analytics = analytics;
    }

    public CompletableFuture<Void> trackEngagement(Iterable<Engagement> events) throws StreamException {
        return this.trackEngagement((Engagement[])Iterables.toArray(events, Engagement.class));
    }

    public CompletableFuture<Void> trackEngagement(Engagement ... events) throws StreamException {
        Token token = Auth.buildAnalyticsToken(this.secret, Auth.TokenAction.WRITE);
        return this.analytics.trackEngagement(token, events);
    }

    public CompletableFuture<Void> trackImpression(Impression event) throws StreamException {
        Token token = Auth.buildAnalyticsToken(this.secret, Auth.TokenAction.WRITE);
        return this.analytics.trackImpression(token, event);
    }

    public URL createRedirectURL(URL url, Engagement ... engagements) throws StreamException {
        return this.createRedirectURL(url, new Impression[0], engagements);
    }

    public URL createRedirectURL(URL url, Impression ... impressions) throws StreamException {
        return this.createRedirectURL(url, impressions, new Engagement[0]);
    }

    public URL createRedirectURL(URL url, Iterable<Impression> impressions, Iterable<Engagement> engagements) throws StreamException {
        return this.createRedirectURL(url, (Impression[])Iterables.toArray(impressions, Impression.class), (Engagement[])Iterables.toArray(engagements, Engagement.class));
    }

    public URL createRedirectURL(URL url, Impression[] impressions, Engagement[] engagements) throws StreamException {
        Token token = Auth.buildAnalyticsRedirectToken(this.secret);
        return this.analytics.createRedirectURL(token, url, impressions, engagements);
    }
}

