/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.cloud;

import io.getstream.cloud.CloudClient;
import io.getstream.cloud.CloudFeed;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.models.Activity;
import io.getstream.core.models.EnrichedActivity;
import io.getstream.core.models.FeedID;
import io.getstream.core.options.EnrichmentFlags;
import io.getstream.core.options.Filter;
import io.getstream.core.options.Offset;
import io.getstream.core.options.Ranking;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.DefaultOptions;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class CloudFlatFeed
extends CloudFeed {
    CloudFlatFeed(CloudClient client, FeedID id) {
        super(client, id);
    }

    public CompletableFuture<List<Activity>> getActivities() throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, null);
    }

    public CompletableFuture<List<Activity>> getActivities(String ranking) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public CompletableFuture<List<Activity>> getActivities(Filter filter) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_OFFSET, filter, null);
    }

    public CompletableFuture<List<Activity>> getActivities(Offset offset) throws StreamException {
        return this.getActivities(offset, DefaultOptions.DEFAULT_FILTER, null);
    }

    public CompletableFuture<List<Activity>> getActivities(Filter filter, String ranking) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_OFFSET, filter, ranking);
    }

    public CompletableFuture<List<Activity>> getActivities(Offset offset, String ranking) throws StreamException {
        return this.getActivities(offset, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    CompletableFuture<List<Activity>> getActivities(Offset offset, Filter filter, String ranking) throws StreamException {
        RequestOption[] requestOptionArray;
        if (ranking == null) {
            RequestOption[] requestOptionArray2 = new RequestOption[3];
            requestOptionArray2[0] = offset;
            requestOptionArray2[1] = filter;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[2] = DefaultOptions.DEFAULT_MARKER;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[4];
            requestOptionArray3[0] = offset;
            requestOptionArray3[1] = filter;
            requestOptionArray3[2] = DefaultOptions.DEFAULT_MARKER;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[3] = new Ranking(ranking);
        }
        RequestOption[] options = requestOptionArray;
        return this.getClient().getActivities(this.getID(), options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, Activity.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, null);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, String ranking) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Filter filter) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_OFFSET, filter, null);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Offset offset) throws StreamException {
        return this.getCustomActivities(type, offset, DefaultOptions.DEFAULT_FILTER, null);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Offset offset, String ranking) throws StreamException {
        return this.getCustomActivities(type, offset, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Filter filter, String ranking) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_OFFSET, filter, ranking);
    }

    <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Offset offset, Filter filter, String ranking) throws StreamException {
        RequestOption[] requestOptionArray;
        if (ranking == null) {
            RequestOption[] requestOptionArray2 = new RequestOption[3];
            requestOptionArray2[0] = offset;
            requestOptionArray2[1] = filter;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[2] = DefaultOptions.DEFAULT_MARKER;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[4];
            requestOptionArray3[0] = offset;
            requestOptionArray3[1] = filter;
            requestOptionArray3[2] = DefaultOptions.DEFAULT_MARKER;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[3] = new Ranking(ranking);
        }
        RequestOption[] options = requestOptionArray;
        return this.getClient().getActivities(this.getID(), options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, type);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities() throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Filter filter) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Offset offset) throws StreamException {
        return this.getEnrichedActivities(offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_OFFSET, filter, flags, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Offset offset, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(offset, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Filter filter, String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Offset offset, String ranking) throws StreamException {
        return this.getEnrichedActivities(offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_OFFSET, filter, flags, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Offset offset, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedActivities(offset, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Offset offset, Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        RequestOption[] requestOptionArray;
        if (ranking == null) {
            RequestOption[] requestOptionArray2 = new RequestOption[4];
            requestOptionArray2[0] = offset;
            requestOptionArray2[1] = filter;
            requestOptionArray2[2] = flags;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[3] = DefaultOptions.DEFAULT_MARKER;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[5];
            requestOptionArray3[0] = offset;
            requestOptionArray3[1] = filter;
            requestOptionArray3[2] = flags;
            requestOptionArray3[3] = DefaultOptions.DEFAULT_MARKER;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[4] = new Ranking(ranking);
        }
        RequestOption[] options = requestOptionArray;
        return this.getClient().getEnrichedActivities(this.getID(), options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, EnrichedActivity.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Filter filter) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_OFFSET, filter, flags, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Offset offset) throws StreamException {
        return this.getEnrichedCustomActivities(type, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Offset offset, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, offset, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Offset offset, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Offset offset, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, offset, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Filter filter, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_OFFSET, filter, flags, ranking);
    }

    <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Offset offset, Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        RequestOption[] requestOptionArray;
        if (ranking == null) {
            RequestOption[] requestOptionArray2 = new RequestOption[4];
            requestOptionArray2[0] = offset;
            requestOptionArray2[1] = filter;
            requestOptionArray2[2] = flags;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[3] = DefaultOptions.DEFAULT_MARKER;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[5];
            requestOptionArray3[0] = offset;
            requestOptionArray3[1] = filter;
            requestOptionArray3[2] = flags;
            requestOptionArray3[3] = DefaultOptions.DEFAULT_MARKER;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[4] = new Ranking(ranking);
        }
        RequestOption[] options = requestOptionArray;
        return this.getClient().getActivities(this.getID(), options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, type);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }
}

