/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.Token;
import io.getstream.core.models.Activity;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.FollowRelation;
import io.getstream.core.models.ForeignIDTimePair;
import io.getstream.core.options.CustomQueryParameter;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Request;
import io.getstream.core.utils.Routes;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class StreamBatch {
    private final String key;
    private final URL baseURL;
    private final HTTPClient httpClient;

    public StreamBatch(String key, URL baseURL, HTTPClient httpClient) {
        this.key = key;
        this.baseURL = baseURL;
        this.httpClient = httpClient;
    }

    public CompletableFuture<Void> addToMany(Token token, Activity activity, FeedID ... feeds) throws StreamException {
        Preconditions.checkNotNull((Object)activity, (Object)"Missing activity");
        Preconditions.checkNotNull((Object)feeds, (Object)"No feeds to add to");
        Preconditions.checkArgument((feeds.length > 0 ? 1 : 0) != 0, (Object)"No feeds to add to");
        final Activity data = activity;
        final String[] feedIDs = (String[])Arrays.stream(feeds).map(feed -> feed.toString()).toArray(String[]::new);
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public final Activity activity;
                public final String[] feeds;
                {
                    this.activity = data;
                    this.feeds = feedIDs;
                }
            });
            URL url = Routes.buildAddToManyURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> followMany(Token token, int activityCopyLimit, FollowRelation ... follows) throws StreamException {
        Preconditions.checkArgument((activityCopyLimit >= 0 ? 1 : 0) != 0, (Object)"Activity copy limit must be non negative");
        Preconditions.checkNotNull((Object)follows, (Object)"No feeds to follow");
        Preconditions.checkArgument((follows.length > 0 ? 1 : 0) != 0, (Object)"No feeds to follow");
        try {
            byte[] payload = Serialization.toJSON(follows);
            URL url = Routes.buildFollowManyURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new CustomQueryParameter("activity_copy_limit", Integer.toString(activityCopyLimit)))).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> unfollowMany(Token token, FollowRelation ... follows) throws StreamException {
        Preconditions.checkNotNull((Object)follows, (Object)"No feeds to unfollow");
        Preconditions.checkArgument((follows.length > 0 ? 1 : 0) != 0, (Object)"No feeds to unfollow");
        try {
            byte[] payload = Serialization.toJSON(follows);
            URL url = Routes.buildUnfollowManyURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<List<Activity>> getActivitiesByID(Token token, String ... activityIDs) throws StreamException {
        Preconditions.checkNotNull((Object)activityIDs, (Object)"No activities to update");
        Preconditions.checkArgument((activityIDs.length > 0 ? 1 : 0) != 0, (Object)"No activities to update");
        try {
            URL url = Routes.buildActivitiesURL(this.baseURL);
            return this.httpClient.execute(Request.buildGet(url, this.key, token, new CustomQueryParameter("ids", String.join((CharSequence)",", activityIDs)))).thenApply(response -> {
                try {
                    return Serialization.deserializeContainer(response, Activity.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<List<Activity>> getActivitiesByForeignID(Token token, ForeignIDTimePair ... activityIDTimePairs) throws StreamException {
        Preconditions.checkNotNull((Object)activityIDTimePairs, (Object)"No activities to get");
        Preconditions.checkArgument((activityIDTimePairs.length > 0 ? 1 : 0) != 0, (Object)"No activities to get");
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        timestampFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        timestampFormat.setLenient(false);
        CharSequence[] foreignIDs = (String[])Arrays.stream(activityIDTimePairs).map(pair -> pair.getForeignID()).toArray(String[]::new);
        CharSequence[] timestamps = (String[])Arrays.stream(activityIDTimePairs).map(pair -> timestampFormat.format(pair.getTime())).toArray(String[]::new);
        try {
            URL url = Routes.buildActivitiesURL(this.baseURL);
            RequestOption[] options = new RequestOption[]{new CustomQueryParameter("foreign_ids", String.join((CharSequence)",", foreignIDs)), new CustomQueryParameter("timestamps", String.join((CharSequence)",", timestamps))};
            return this.httpClient.execute(Request.buildGet(url, this.key, token, options)).thenApply(response -> {
                try {
                    return Serialization.deserializeContainer(response, Activity.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> updateActivities(Token token, Activity ... activities) throws StreamException {
        Preconditions.checkNotNull((Object)activities, (Object)"No activities to update");
        Preconditions.checkArgument((activities.length > 0 ? 1 : 0) != 0, (Object)"No activities to update");
        try {
            final Activity[] data = activities;
            byte[] payload = Serialization.toJSON(new Object(){
                public final Activity[] activities;
                {
                    this.activities = data;
                }
            });
            URL url = Routes.buildActivitiesURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }
}

