/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.getstream.core.LookupKind;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.Token;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.Reaction;
import io.getstream.core.options.CustomQueryParameter;
import io.getstream.core.options.Filter;
import io.getstream.core.options.Limit;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Request;
import io.getstream.core.utils.Routes;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class StreamReactions {
    private final String key;
    private final URL baseURL;
    private final HTTPClient httpClient;

    StreamReactions(String key, URL baseURL, HTTPClient httpClient) {
        this.key = key;
        this.baseURL = baseURL;
        this.httpClient = httpClient;
    }

    public CompletableFuture<Reaction> get(Token token, String id) throws StreamException {
        Preconditions.checkNotNull((Object)id, (Object)"Reaction id can't be null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Reaction id can't be empty");
        try {
            URL url = Routes.buildReactionsURL(this.baseURL, id + '/');
            return this.httpClient.execute(Request.buildGet(url, this.key, token, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserialize(response, Reaction.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<List<Reaction>> filter(Token token, LookupKind lookup, String id, Filter filter, Limit limit, String kind) throws StreamException {
        Preconditions.checkNotNull((Object)((Object)lookup), (Object)"Lookup kind can't be null");
        Preconditions.checkNotNull((Object)id, (Object)"Reaction ID can't be null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Reaction ID can't be empty");
        Preconditions.checkNotNull((Object)filter, (Object)"Filter can't be null");
        Preconditions.checkNotNull((Object)kind, (Object)"Kind can't be null");
        try {
            URL url = Routes.buildReactionsURL(this.baseURL, lookup.getKind() + '/' + id + '/');
            CustomQueryParameter reactionType = new CustomQueryParameter("kind", kind);
            CustomQueryParameter withActivityData = new CustomQueryParameter("with_activity_data", Boolean.toString(lookup == LookupKind.ACTIVITY_WITH_DATA));
            return this.httpClient.execute(Request.buildGet(url, this.key, token, filter, limit, reactionType, withActivityData)).thenApply(response -> {
                try {
                    return Serialization.deserializeContainer(response, Reaction.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Reaction> add(Token token, String userID, Reaction reaction, FeedID ... targetFeeds) throws StreamException {
        Preconditions.checkNotNull((Object)reaction, (Object)"Reaction can't be null");
        Preconditions.checkArgument((reaction.getActivityID() != null || reaction.getParent() != null ? 1 : 0) != 0, (Object)"Reaction has to either have and activity ID or parent");
        Preconditions.checkArgument((reaction.getActivityID() == null || reaction.getParent() == null ? 1 : 0) != 0, (Object)"Reaction can't have both activity ID and parent");
        if (reaction.getActivityID() != null) {
            Preconditions.checkArgument((!reaction.getActivityID().isEmpty() ? 1 : 0) != 0, (Object)"Reaction activity ID can't be empty");
        }
        if (reaction.getParent() != null) {
            Preconditions.checkArgument((!reaction.getParent().isEmpty() ? 1 : 0) != 0, (Object)"Reaction parent can't be empty");
        }
        Preconditions.checkNotNull((Object)reaction.getKind(), (Object)"Reaction kind can't be null");
        Preconditions.checkArgument((!reaction.getKind().isEmpty() ? 1 : 0) != 0, (Object)"Reaction kind can't be empty");
        String[] targetFeedIDs = (String[])Arrays.stream(targetFeeds).map(feed -> feed.toString()).toArray(String[]::new);
        try {
            ImmutableMap.Builder payloadBuilder = ImmutableMap.builder();
            payloadBuilder.put((Object)"kind", (Object)reaction.getKind());
            payloadBuilder.put((Object)"target_feeds", (Object)targetFeedIDs);
            if (reaction.getActivityID() != null) {
                payloadBuilder.put((Object)"activity_id", (Object)reaction.getActivityID());
            }
            if (userID != null || reaction.getUserID() != null) {
                payloadBuilder.put((Object)"user_id", MoreObjects.firstNonNull((Object)userID, (Object)reaction.getUserID()));
            }
            if (reaction.getParent() != null) {
                payloadBuilder.put((Object)"parent", (Object)reaction.getParent());
            }
            if (reaction.getId() != null) {
                payloadBuilder.put((Object)"id", (Object)reaction.getId());
            }
            if (reaction.getExtra() != null) {
                payloadBuilder.put((Object)"data", reaction.getExtra());
            }
            byte[] payload = Serialization.toJSON(payloadBuilder.build());
            URL url = Routes.buildReactionsURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserialize(response, Reaction.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> update(Token token, final Reaction reaction, FeedID ... targetFeeds) throws StreamException {
        Preconditions.checkNotNull((Object)reaction, (Object)"Reaction can't be null");
        Preconditions.checkNotNull((Object)reaction.getId(), (Object)"Reaction id can't be null");
        Preconditions.checkArgument((!reaction.getId().isEmpty() ? 1 : 0) != 0, (Object)"Reaction id can't be empty");
        final String[] targetFeedIDs = (String[])Arrays.stream(targetFeeds).map(feed -> feed.toString()).toArray(String[]::new);
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public final Map<String, Object> data;
                public final String[] target_feeds;
                {
                    this.data = reaction.getExtra();
                    this.target_feeds = targetFeedIDs;
                }
            });
            URL url = Routes.buildReactionsURL(this.baseURL, reaction.getId() + '/');
            return this.httpClient.execute(Request.buildPut(url, this.key, token, payload, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> delete(Token token, String id) throws StreamException {
        Preconditions.checkNotNull((Object)id, (Object)"Reaction id can't be null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Reaction id can't be empty");
        try {
            URL url = Routes.buildReactionsURL(this.baseURL, id + '/');
            return this.httpClient.execute(Request.buildDelete(url, this.key, token, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }
}

