/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.options;

import com.google.common.base.Preconditions;
import io.getstream.core.http.Request;
import io.getstream.core.options.RequestOption;

public final class CustomQueryParameter
implements RequestOption {
    private final String name;
    private final String value;

    public CustomQueryParameter(String name, String value) {
        Preconditions.checkNotNull((Object)name, (Object)"Missing query parameter name");
        Preconditions.checkNotNull((Object)value, (Object)"Missing query parameter value");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Query parameter name can't be empty");
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void apply(Request.Builder builder) {
        builder.addQueryParameter(this.name, this.value);
    }
}

