/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.getstream.client.AggregatedFeed;
import io.getstream.client.AnalyticsClient;
import io.getstream.client.BatchClient;
import io.getstream.client.CollectionsClient;
import io.getstream.client.FileStorageClient;
import io.getstream.client.FlatFeed;
import io.getstream.client.ImageStorageClient;
import io.getstream.client.NotificationFeed;
import io.getstream.client.PersonalizationClient;
import io.getstream.client.ReactionsClient;
import io.getstream.client.User;
import io.getstream.core.Region;
import io.getstream.core.Stream;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.OKHTTPClientAdapter;
import io.getstream.core.http.Response;
import io.getstream.core.http.Token;
import io.getstream.core.models.Activity;
import io.getstream.core.models.ActivityUpdate;
import io.getstream.core.models.Data;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.ForeignIDTimePair;
import io.getstream.core.models.OGData;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Auth;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java8.util.concurrent.CompletableFuture;

public final class Client {
    private final String secret;
    private final Stream stream;

    private Client(String key, String secret, URL baseURL, HTTPClient httpClient) {
        this.secret = secret;
        this.stream = new Stream(key, baseURL, httpClient);
    }

    public static Builder builder(String apiKey, String secret) {
        return new Builder(apiKey, secret);
    }

    public CompletableFuture<Activity> updateActivityByID(String id, Map<String, Object> set, Iterable<String> unset) throws StreamException {
        return this.updateActivityByID(id, set, (String[])Iterables.toArray(unset, String.class));
    }

    public CompletableFuture<Activity> updateActivityByID(ActivityUpdate update) throws StreamException {
        return this.updateActivityByID(update.getID(), update.getSet(), update.getUnset());
    }

    public CompletableFuture<Activity> updateActivityByID(String id, Map<String, Object> set, String[] unset) throws StreamException {
        Token token = Auth.buildActivityToken(this.secret, Auth.TokenAction.WRITE);
        return this.stream.updateActivityByID(token, id, set, unset);
    }

    public CompletableFuture<Activity> updateActivityByForeignID(ForeignIDTimePair foreignIDTimePair, Map<String, Object> set, Iterable<String> unset) throws StreamException {
        Preconditions.checkNotNull((Object)foreignIDTimePair, (Object)"No activity to update");
        return this.updateActivityByForeignID(foreignIDTimePair.getForeignID(), foreignIDTimePair.getTime(), set, unset);
    }

    public CompletableFuture<Activity> updateActivityByForeignID(ForeignIDTimePair foreignIDTimePair, Map<String, Object> set, String[] unset) throws StreamException {
        Preconditions.checkNotNull((Object)foreignIDTimePair, (Object)"No activity to update");
        return this.updateActivityByForeignID(foreignIDTimePair.getForeignID(), foreignIDTimePair.getTime(), set, unset);
    }

    public CompletableFuture<Activity> updateActivityByForeignID(String foreignID, Date timestamp, Map<String, Object> set, Iterable<String> unset) throws StreamException {
        return this.updateActivityByForeignID(foreignID, timestamp, set, (String[])Iterables.toArray(unset, String.class));
    }

    public CompletableFuture<Activity> updateActivityByForeignID(ActivityUpdate update) throws StreamException {
        return this.updateActivityByForeignID(update.getForeignID(), update.getTime(), update.getSet(), update.getUnset());
    }

    public CompletableFuture<Activity> updateActivityByForeignID(String foreignID, Date timestamp, Map<String, Object> set, String[] unset) throws StreamException {
        Token token = Auth.buildActivityToken(this.secret, Auth.TokenAction.WRITE);
        return this.stream.updateActivityByForeignID(token, foreignID, timestamp, set, unset);
    }

    public CompletableFuture<OGData> openGraph(URL url) throws StreamException {
        Token token = Auth.buildOpenGraphToken(this.secret);
        return this.stream.openGraph(token, url);
    }

    public CompletableFuture<List<Activity>> updateActivitiesByID(Iterable<ActivityUpdate> updates) throws StreamException {
        return this.updateActivitiesByID((ActivityUpdate[])Iterables.toArray(updates, ActivityUpdate.class));
    }

    public CompletableFuture<List<Activity>> updateActivitiesByID(ActivityUpdate ... updates) throws StreamException {
        Token token = Auth.buildActivityToken(this.secret, Auth.TokenAction.WRITE);
        return this.stream.updateActivitiesByID(token, updates);
    }

    public CompletableFuture<List<Activity>> updateActivitiesByForeignID(Iterable<ActivityUpdate> updates) throws StreamException {
        return this.updateActivitiesByForeignID((ActivityUpdate[])Iterables.toArray(updates, ActivityUpdate.class));
    }

    public CompletableFuture<List<Activity>> updateActivitiesByForeignID(ActivityUpdate ... updates) throws StreamException {
        Token token = Auth.buildActivityToken(this.secret, Auth.TokenAction.WRITE);
        return this.stream.updateActivitiesByForeignID(token, updates);
    }

    public <T> T getHTTPClientImplementation() {
        return this.stream.getHTTPClientImplementation();
    }

    public Token frontendToken(String userID) {
        return Auth.buildFrontendToken(this.secret, userID);
    }

    public FlatFeed flatFeed(FeedID id) {
        return new FlatFeed(this, id);
    }

    public FlatFeed flatFeed(String slug, String userID) {
        return this.flatFeed(new FeedID(slug, userID));
    }

    public AggregatedFeed aggregatedFeed(FeedID id) {
        return new AggregatedFeed(this, id);
    }

    public AggregatedFeed aggregatedFeed(String slug, String userID) {
        return this.aggregatedFeed(new FeedID(slug, userID));
    }

    public NotificationFeed notificationFeed(FeedID id) {
        return new NotificationFeed(this, id);
    }

    public NotificationFeed notificationFeed(String slug, String userID) {
        return this.notificationFeed(new FeedID(slug, userID));
    }

    public User user(String userID) {
        return new User(this, userID);
    }

    public BatchClient batch() {
        return new BatchClient(this.secret, this.stream.batch());
    }

    public CollectionsClient collections() {
        return new CollectionsClient(this.secret, this.stream.collections());
    }

    public PersonalizationClient personalization() {
        return new PersonalizationClient(this.secret, this.stream.personalization());
    }

    public AnalyticsClient analytics() {
        return new AnalyticsClient(this.secret, this.stream.analytics());
    }

    public ReactionsClient reactions() {
        return new ReactionsClient(this.secret, this.stream.reactions());
    }

    public FileStorageClient files() {
        return new FileStorageClient(this.secret, this.stream.files());
    }

    public ImageStorageClient images() {
        return new ImageStorageClient(this.secret, this.stream.images());
    }

    CompletableFuture<Response> getActivities(FeedID feed, RequestOption ... options) throws StreamException {
        Token token = Auth.buildFeedToken(this.secret, feed, Auth.TokenAction.READ);
        return this.stream.getActivities(token, feed, options);
    }

    CompletableFuture<Response> getEnrichedActivities(FeedID feed, RequestOption ... options) throws StreamException {
        Token token = Auth.buildFeedToken(this.secret, feed, Auth.TokenAction.READ);
        return this.stream.getEnrichedActivities(token, feed, options);
    }

    CompletableFuture<Response> addActivity(FeedID feed, Activity activity) throws StreamException {
        Token token = Auth.buildFeedToken(this.secret, feed, Auth.TokenAction.WRITE);
        return this.stream.addActivity(token, feed, activity);
    }

    CompletableFuture<Response> addActivities(FeedID feed, Activity ... activities) throws StreamException {
        Token token = Auth.buildFeedToken(this.secret, feed, Auth.TokenAction.WRITE);
        return this.stream.addActivities(token, feed, activities);
    }

    CompletableFuture<Response> removeActivityByID(FeedID feed, String id) throws StreamException {
        Token token = Auth.buildFeedToken(this.secret, feed, Auth.TokenAction.DELETE);
        return this.stream.removeActivityByID(token, feed, id);
    }

    CompletableFuture<Response> removeActivityByForeignID(FeedID feed, String foreignID) throws StreamException {
        Token token = Auth.buildFeedToken(this.secret, feed, Auth.TokenAction.DELETE);
        return this.stream.removeActivityByForeignID(token, feed, foreignID);
    }

    CompletableFuture<Response> follow(FeedID source, FeedID target, int activityCopyLimit) throws StreamException {
        Token token = Auth.buildFollowToken(this.secret, source, Auth.TokenAction.WRITE);
        Token targetToken = Auth.buildFeedToken(this.secret, target, Auth.TokenAction.READ);
        return this.stream.follow(token, targetToken, source, target, activityCopyLimit);
    }

    CompletableFuture<Response> getFollowers(FeedID feed, RequestOption ... options) throws StreamException {
        Token token = Auth.buildFollowToken(this.secret, feed, Auth.TokenAction.READ);
        return this.stream.getFollowers(token, feed, options);
    }

    CompletableFuture<Response> getFollowed(FeedID feed, RequestOption ... options) throws StreamException {
        Token token = Auth.buildFollowToken(this.secret, feed, Auth.TokenAction.READ);
        return this.stream.getFollowed(token, feed, options);
    }

    CompletableFuture<Response> unfollow(FeedID source, FeedID target, RequestOption ... options) throws StreamException {
        Token token = Auth.buildFollowToken(this.secret, source, Auth.TokenAction.DELETE);
        return this.stream.unfollow(token, source, target, options);
    }

    CompletableFuture<Response> updateActivityToTargets(FeedID feed, Activity activity, FeedID[] add, FeedID[] remove, FeedID[] newTargets) throws StreamException {
        Token token = Auth.buildToTargetUpdateToken(this.secret, feed, Auth.TokenAction.WRITE);
        return this.stream.updateActivityToTargets(token, feed, activity, add, remove, newTargets);
    }

    CompletableFuture<Response> getUser(String id) throws StreamException {
        Token token = Auth.buildUsersToken(this.secret, Auth.TokenAction.READ);
        return this.stream.getUser(token, id, false);
    }

    CompletableFuture<Response> deleteUser(String id) throws StreamException {
        Token token = Auth.buildUsersToken(this.secret, Auth.TokenAction.DELETE);
        return this.stream.deleteUser(token, id);
    }

    CompletableFuture<Response> getOrCreateUser(String id, Data data) throws StreamException {
        Token token = Auth.buildUsersToken(this.secret, Auth.TokenAction.WRITE);
        return this.stream.createUser(token, id, data, true);
    }

    CompletableFuture<Response> createUser(String id, Data data) throws StreamException {
        Token token = Auth.buildUsersToken(this.secret, Auth.TokenAction.WRITE);
        return this.stream.createUser(token, id, data, false);
    }

    CompletableFuture<Response> updateUser(String id, Data data) throws StreamException {
        Token token = Auth.buildUsersToken(this.secret, Auth.TokenAction.WRITE);
        return this.stream.updateUser(token, id, data);
    }

    CompletableFuture<Response> userProfile(String id) throws StreamException {
        Token token = Auth.buildUsersToken(this.secret, Auth.TokenAction.READ);
        return this.stream.getUser(token, id, true);
    }

    public static final class Builder {
        private static final String DEFAULT_HOST = "stream-io-api.com";
        private final String apiKey;
        private final String secret;
        private HTTPClient httpClient;
        private String scheme = "https";
        private String region = Region.US_EAST.toString();
        private String host = "stream-io-api.com";
        private int port = 443;

        public Builder(String apiKey, String secret) {
            Preconditions.checkNotNull((Object)apiKey, (Object)"API key can't be null");
            Preconditions.checkNotNull((Object)secret, (Object)"Secret can't be null");
            Preconditions.checkArgument((!apiKey.isEmpty() ? 1 : 0) != 0, (Object)"API key can't be empty");
            Preconditions.checkArgument((!secret.isEmpty() ? 1 : 0) != 0, (Object)"Secret can't be empty");
            this.apiKey = apiKey;
            this.secret = secret;
        }

        public Builder httpClient(HTTPClient httpClient) {
            Preconditions.checkNotNull((Object)httpClient, (Object)"HTTP client can't be null");
            this.httpClient = httpClient;
            return this;
        }

        public Builder scheme(String scheme) {
            Preconditions.checkNotNull((Object)scheme, (Object)"Scheme can't be null");
            Preconditions.checkArgument((!scheme.isEmpty() ? 1 : 0) != 0, (Object)"Scheme can't be empty");
            this.scheme = scheme;
            return this;
        }

        public Builder host(String host) {
            Preconditions.checkNotNull((Object)host, (Object)"Host can't be null");
            Preconditions.checkArgument((!host.isEmpty() ? 1 : 0) != 0, (Object)"Host can't be empty");
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port has to be a non-zero positive number");
            this.port = port;
            return this;
        }

        public Builder region(Region region) {
            Preconditions.checkNotNull((Object)((Object)region), (Object)"Region can't be null");
            this.region = region.toString();
            return this;
        }

        public Builder region(String region) {
            Preconditions.checkNotNull((Object)region, (Object)"Region can't be null");
            Preconditions.checkArgument((!region.isEmpty() ? 1 : 0) != 0, (Object)"Region can't be empty");
            this.region = region;
            return this;
        }

        private String buildHost() {
            StringBuilder sb = new StringBuilder();
            if (this.host.equals(DEFAULT_HOST)) {
                sb.append(this.region).append(".");
            }
            sb.append(this.host);
            return sb.toString();
        }

        public Client build() throws MalformedURLException {
            if (this.httpClient == null) {
                this.httpClient = new OKHTTPClientAdapter();
            }
            return new Client(this.apiKey, this.secret, new URL(this.scheme, this.buildHost(), this.port, ""), this.httpClient);
        }
    }
}

