/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import com.google.common.base.Preconditions;
import io.getstream.client.Client;
import io.getstream.client.User$$Lambda$1;
import io.getstream.client.User$$Lambda$2;
import io.getstream.client.User$$Lambda$3;
import io.getstream.client.User$$Lambda$4;
import io.getstream.client.User$$Lambda$5;
import io.getstream.client.User$$Lambda$6;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Response;
import io.getstream.core.models.Data;
import io.getstream.core.models.ProfileData;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java8.util.concurrent.CompletableFuture;
import java8.util.concurrent.CompletionException;

public final class User {
    private final Client client;
    private final String id;

    public User(Client client, String id) {
        Preconditions.checkNotNull((Object)client, (Object)"Client can't be null");
        Preconditions.checkNotNull((Object)id, (Object)"User ID can't be null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"User ID can't be empty");
        this.client = client;
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public CompletableFuture<Data> get() throws StreamException {
        return this.client.getUser(this.id).thenApply(User$$Lambda$1.lambdaFactory$());
    }

    public CompletableFuture<Void> delete() throws StreamException {
        return this.client.deleteUser(this.id).thenApply(User$$Lambda$2.lambdaFactory$());
    }

    public CompletableFuture<Data> getOrCreate() throws StreamException {
        return this.getOrCreate(new Data());
    }

    public CompletableFuture<Data> getOrCreate(Data data) throws StreamException {
        return this.client.getOrCreateUser(this.id, data).thenApply(User$$Lambda$3.lambdaFactory$());
    }

    public CompletableFuture<Data> create() throws StreamException {
        return this.create(new Data());
    }

    public CompletableFuture<Data> create(Data data) throws StreamException {
        return this.client.createUser(this.id, data).thenApply(User$$Lambda$4.lambdaFactory$());
    }

    public CompletableFuture<Data> update(Data data) throws StreamException {
        return this.client.updateUser(this.id, data).thenApply(User$$Lambda$5.lambdaFactory$());
    }

    public CompletableFuture<ProfileData> profile() throws StreamException {
        return this.client.userProfile(this.id).thenApply(User$$Lambda$6.lambdaFactory$());
    }

    static /* synthetic */ ProfileData lambda$profile$5(Response response) {
        try {
            return Serialization.deserialize(response, ProfileData.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Data lambda$update$4(Response response) {
        try {
            return Serialization.deserialize(response, Data.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Data lambda$create$3(Response response) {
        try {
            return Serialization.deserialize(response, Data.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Data lambda$getOrCreate$2(Response response) {
        try {
            return Serialization.deserialize(response, Data.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Void lambda$delete$1(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Data lambda$get$0(Response response) {
        try {
            return Serialization.deserialize(response, Data.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }
}

