/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import com.google.common.collect.Iterables;
import io.getstream.client.BatchClient$$Lambda$1;
import io.getstream.client.BatchClient$$Lambda$4;
import io.getstream.client.BatchClient$$Lambda$5;
import io.getstream.client.BatchClient$$Lambda$6;
import io.getstream.core.KeepHistory;
import io.getstream.core.StreamBatch;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Token;
import io.getstream.core.models.Activity;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.FollowRelation;
import io.getstream.core.models.ForeignIDTimePair;
import io.getstream.core.models.UnfollowOperation;
import io.getstream.core.utils.Auth;
import java.util.List;
import java8.util.J8Arrays;
import java8.util.concurrent.CompletableFuture;

public final class BatchClient {
    private final String secret;
    private final StreamBatch batch;

    BatchClient(String secret, StreamBatch batch) {
        this.secret = secret;
        this.batch = batch;
    }

    public CompletableFuture<Void> addToMany(Activity activity, FeedID ... feeds) throws StreamException {
        Token token = Auth.buildFeedToken(this.secret, Auth.TokenAction.WRITE);
        return this.batch.addToMany(token, activity, feeds);
    }

    public CompletableFuture<Void> followMany(int activityCopyLimit, FollowRelation ... follows) throws StreamException {
        Token token = Auth.buildFollowToken(this.secret, Auth.TokenAction.WRITE);
        return this.batch.followMany(token, activityCopyLimit, follows);
    }

    public CompletableFuture<Void> followMany(int activityCopyLimit, Iterable<FollowRelation> follows) throws StreamException {
        return this.followMany(activityCopyLimit, (FollowRelation[])Iterables.toArray(follows, FollowRelation.class));
    }

    public CompletableFuture<Void> followMany(FollowRelation ... follows) throws StreamException {
        return this.followMany(100, follows);
    }

    public CompletableFuture<Void> followMany(Iterable<FollowRelation> follows) throws StreamException {
        return this.followMany((FollowRelation[])Iterables.toArray(follows, FollowRelation.class));
    }

    public CompletableFuture<Void> unfollowMany(FollowRelation ... follows) throws StreamException {
        Token token = Auth.buildFollowToken(this.secret, Auth.TokenAction.WRITE);
        UnfollowOperation[] ops = (UnfollowOperation[])J8Arrays.stream((Object[])follows).map(BatchClient$$Lambda$1.lambdaFactory$()).toArray(BatchClient$$Lambda$4.lambdaFactory$());
        return this.batch.unfollowMany(token, ops);
    }

    public CompletableFuture<Void> unfollowMany(KeepHistory keepHistory, FollowRelation ... follows) throws StreamException {
        Token token = Auth.buildFollowToken(this.secret, Auth.TokenAction.WRITE);
        UnfollowOperation[] ops = (UnfollowOperation[])J8Arrays.stream((Object[])follows).map(BatchClient$$Lambda$5.lambdaFactory$(keepHistory)).toArray(BatchClient$$Lambda$6.lambdaFactory$());
        return this.batch.unfollowMany(token, ops);
    }

    public CompletableFuture<Void> unfollowMany(UnfollowOperation ... unfollows) throws StreamException {
        Token token = Auth.buildFollowToken(this.secret, Auth.TokenAction.WRITE);
        return this.batch.unfollowMany(token, unfollows);
    }

    public CompletableFuture<List<Activity>> getActivitiesByID(Iterable<String> activityIDs) throws StreamException {
        return this.getActivitiesByID((String[])Iterables.toArray(activityIDs, String.class));
    }

    public CompletableFuture<List<Activity>> getActivitiesByID(String ... activityIDs) throws StreamException {
        Token token = Auth.buildActivityToken(this.secret, Auth.TokenAction.READ);
        return this.batch.getActivitiesByID(token, activityIDs);
    }

    public CompletableFuture<List<Activity>> getActivitiesByForeignID(Iterable<ForeignIDTimePair> activityIDTimePairs) throws StreamException {
        return this.getActivitiesByForeignID((ForeignIDTimePair[])Iterables.toArray(activityIDTimePairs, ForeignIDTimePair.class));
    }

    public CompletableFuture<List<Activity>> getActivitiesByForeignID(ForeignIDTimePair ... activityIDTimePairs) throws StreamException {
        Token token = Auth.buildActivityToken(this.secret, Auth.TokenAction.READ);
        return this.batch.getActivitiesByForeignID(token, activityIDTimePairs);
    }

    public CompletableFuture<Void> updateActivities(Iterable<Activity> activities) throws StreamException {
        return this.updateActivities((Activity[])Iterables.toArray(activities, Activity.class));
    }

    public CompletableFuture<Void> updateActivities(Activity ... activities) throws StreamException {
        Token token = Auth.buildActivityToken(this.secret, Auth.TokenAction.WRITE);
        return this.batch.updateActivities(token, activities);
    }

    static /* synthetic */ UnfollowOperation[] lambda$unfollowMany$3(int x$0) {
        return new UnfollowOperation[x$0];
    }

    static /* synthetic */ UnfollowOperation lambda$unfollowMany$2(KeepHistory keepHistory, FollowRelation follow) {
        return new UnfollowOperation(follow, keepHistory);
    }

    static /* synthetic */ UnfollowOperation[] lambda$unfollowMany$1(int x$0) {
        return new UnfollowOperation[x$0];
    }

    static /* synthetic */ UnfollowOperation lambda$unfollowMany$0(FollowRelation follow) {
        return new UnfollowOperation(follow, KeepHistory.YES);
    }
}

