/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import io.getstream.core.Moderation;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Response;
import io.getstream.core.http.Token;
import io.getstream.core.utils.Auth;
import java.util.Map;
import java8.util.concurrent.CompletableFuture;

public class ModerationClient {
    private final String secret;
    private final Moderation mod;

    ModerationClient(String secret, Moderation mod) {
        this.secret = secret;
        this.mod = mod;
    }

    public CompletableFuture<Response> flagUser(String flaggedUserId, String reportingUser, String reason, Map<String, Object> options) throws StreamException {
        return this.flag("stream:user", flaggedUserId, reportingUser, reason, options);
    }

    public CompletableFuture<Response> flagActivity(String entityId, String reportingUser, String reason, Map<String, Object> options) throws StreamException {
        return this.flag("stream:feeds:v2:activity", entityId, reportingUser, reason, options);
    }

    public CompletableFuture<Response> flagReaction(String entityId, String reportingUser, String reason, Map<String, Object> options) throws StreamException {
        return this.flag("stream:feeds:v2:reaction", entityId, reportingUser, reason, options);
    }

    private CompletableFuture<Response> flag(String entityType, String entityId, String reportingUser, String reason, Map<String, Object> options) throws StreamException {
        Token token = Auth.buildModerationToken(this.secret, Auth.TokenAction.WRITE);
        return this.mod.flag(token, entityType, entityId, reportingUser, reason, options);
    }
}

