/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core;

import com.google.common.base.Preconditions;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.Token;
import io.getstream.core.options.CustomQueryParameter;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Request;
import io.getstream.core.utils.Routes;
import io.getstream.core.utils.Serialization;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java8.util.concurrent.CompletableFuture;
import java8.util.concurrent.CompletionException;

public class StreamImages {
    private final String key;
    private final URL baseURL;
    private final HTTPClient httpClient;

    StreamImages(String key, URL baseURL, HTTPClient httpClient) {
        this.key = key;
        this.baseURL = baseURL;
        this.httpClient = httpClient;
    }

    public CompletableFuture<URL> upload(Token token, String fileName, byte[] content) throws StreamException {
        Preconditions.checkNotNull((Object)content, (Object)"No data to upload");
        Preconditions.checkArgument((content.length > 0 ? 1 : 0) != 0, (Object)"No data to upload");
        try {
            URL url = Routes.buildImagesURL(this.baseURL);
            return this.httpClient.execute(Request.buildMultiPartPost(url, this.key, token, fileName, content, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserialize(response, "file", URL.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException((Throwable)e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<URL> upload(Token token, File content) throws StreamException {
        Preconditions.checkNotNull((Object)content, (Object)"No file to upload");
        Preconditions.checkArgument((boolean)content.exists(), (Object)"No file to upload");
        try {
            URL url = Routes.buildImagesURL(this.baseURL);
            return this.httpClient.execute(Request.buildMultiPartPost(url, this.key, token, content, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserialize(response, "file", URL.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException((Throwable)e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> delete(Token token, URL targetURL) throws StreamException {
        Preconditions.checkNotNull((Object)targetURL, (Object)"No image to delete");
        try {
            URL url = Routes.buildImagesURL(this.baseURL);
            return this.httpClient.execute(Request.buildDelete(url, this.key, token, new CustomQueryParameter("url", targetURL.toExternalForm()))).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException((Throwable)e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<URL> process(Token token, URL targetURL, RequestOption option) throws StreamException {
        Preconditions.checkNotNull((Object)targetURL, (Object)"No image to process");
        try {
            URL url = Routes.buildImagesURL(this.baseURL);
            return this.httpClient.execute(Request.buildGet(url, this.key, token, option, new CustomQueryParameter("url", targetURL.toExternalForm()))).thenApply(response -> {
                try {
                    return Serialization.deserialize(response, "file", URL.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException((Throwable)e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }
}

