/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.OptBoolean;
import com.google.common.base.MoreObjects;
import io.getstream.core.models.EnrichedActivity;
import io.getstream.core.models.FeedID;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RealtimeMessage {
    private final FeedID feed;
    private final String appID;
    private final List<String> deleted;
    private final List<EnrichedActivity> newActivities;
    private final Date publishedAt;

    @JsonCreator
    public RealtimeMessage(@JsonProperty(value="feed") FeedID feed, @JsonProperty(value="app_id") String appID, @JsonProperty(value="deleted") List<String> deleted, @JsonProperty(value="new") List<EnrichedActivity> newActivities, @JsonProperty(value="published_at") Date publishedAt) {
        this.feed = feed;
        this.appID = appID;
        this.deleted = deleted;
        this.newActivities = newActivities;
        this.publishedAt = publishedAt;
    }

    public FeedID getFeed() {
        return this.feed;
    }

    @JsonProperty(value="app_id")
    public String getAppID() {
        return this.appID;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS", lenient=OptBoolean.FALSE, timezone="UTC")
    public List<String> getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="new")
    public List<EnrichedActivity> getNewActivities() {
        return this.newActivities;
    }

    @JsonProperty(value="published_at")
    public Date getPublishedAt() {
        return this.publishedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealtimeMessage message = (RealtimeMessage)o;
        return Objects.equals(this.feed, message.feed) && Objects.equals(this.appID, message.appID) && Objects.equals(this.deleted, message.deleted) && Objects.equals(this.newActivities, message.newActivities) && Objects.equals(this.publishedAt, message.publishedAt);
    }

    public int hashCode() {
        return Objects.hash(this.feed, this.appID, this.deleted, this.newActivities, this.publishedAt);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("feed", (Object)this.feed).add("appID", (Object)this.appID).add("deleted", this.deleted).add("new", this.newActivities).add("publishedAt", (Object)this.publishedAt).toString();
    }
}

