/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.Response;
import io.getstream.core.http.Token;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Request;
import io.getstream.core.utils.Routes;
import io.getstream.core.utils.Serialization;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java8.util.concurrent.CompletableFuture;
import java8.util.concurrent.CompletionException;

public class Moderation {
    private final String key;
    private final URL baseURL;
    private final HTTPClient httpClient;

    public Moderation(String key, URL baseURL, HTTPClient httpClient) {
        this.key = key;
        this.baseURL = baseURL;
        this.httpClient = httpClient;
    }

    public CompletableFuture<Response> flag(Token token, final String entityType, final String entityId, final String reportingUser, final String Reason, Map<String, Object> options) throws StreamException {
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public final String user_id;
                public final String entity_type;
                public final String entity_id;
                public final String reason;
                {
                    this.user_id = reportingUser;
                    this.entity_type = entityType;
                    this.entity_id = entityId;
                    this.reason = Reason;
                }
            });
            URL url = Routes.buildModerationFlagURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0]));
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new CompletionException(e);
        }
    }
}

