/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import io.getstream.core.models.Data;
import io.getstream.core.models.ModerationResponse;
import io.getstream.core.utils.Serialization;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public class Reaction {
    private final String id;
    private final Integer appID;
    private final String kind;
    private final String userID;
    private final String activityID;
    private final String parent;
    private final Map<String, List<Reaction>> ownChildren;
    private final Map<String, List<Reaction>> latestChildren;
    private final Map<String, Number> childrenCounts;
    private final Data userData;
    private final Map<String, Object> activityData;
    private final Map<String, Object> extra;
    private String moderationTemplate;
    private Map<String, Object> moderation;

    private Reaction(Builder builder) {
        this.id = builder.id;
        this.appID = builder.appID;
        this.kind = builder.kind;
        this.userID = builder.userID;
        this.activityID = builder.activityID;
        this.parent = builder.parent;
        this.ownChildren = builder.ownChildren;
        this.latestChildren = builder.latestChildren;
        this.childrenCounts = builder.childrenCounts;
        this.userData = builder.userData;
        this.activityData = builder.activityData;
        this.extra = builder.extra;
        this.moderationTemplate = builder.moderationTemplate;
        this.moderation = builder.moderation;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="user_id")
    public String getUserID() {
        return this.userID;
    }

    @JsonProperty(value="activity_id")
    public String getActivityID() {
        return this.activityID;
    }

    public String getParent() {
        return this.parent;
    }

    @JsonIgnore
    public Map<String, List<Reaction>> getOwnChildren() {
        return this.ownChildren;
    }

    @JsonIgnore
    public Map<String, List<Reaction>> getLatestChildren() {
        return this.latestChildren;
    }

    @JsonIgnore
    public Map<String, Number> getChildrenCounts() {
        return this.childrenCounts;
    }

    @JsonIgnore
    public Data getUserData() {
        return this.userData;
    }

    @JsonIgnore
    public Map<String, Object> getActivityData() {
        return this.activityData;
    }

    @JsonAnyGetter
    public Map<String, Object> getExtra() {
        return this.extra;
    }

    @JsonProperty(value="moderation_template")
    public String getModerationTemplate() {
        return this.moderationTemplate;
    }

    public void setModerationTemplate(String moderationTemplate) {
        this.moderationTemplate = moderationTemplate;
    }

    @JsonProperty(value="moderation")
    public Map<String, Object> getModeration() {
        return this.moderation;
    }

    public ModerationResponse getModerationResponse() throws Exception {
        String key = "response";
        if (this.moderation != null && this.moderation.containsKey(key)) {
            return Serialization.convert(this.moderation.get(key), ModerationResponse.class);
        }
        throw new Exception("Key '" + key + "' not found in moderation map.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reaction reaction = (Reaction)o;
        return Objects.equals(this.id, reaction.id) && Objects.equals(this.appID, reaction.appID) && Objects.equals(this.kind, reaction.kind) && Objects.equals(this.userID, reaction.userID) && Objects.equals(this.activityID, reaction.activityID) && Objects.equals(this.parent, reaction.parent) && Objects.equals(this.ownChildren, reaction.ownChildren) && Objects.equals(this.latestChildren, reaction.latestChildren) && Objects.equals(this.childrenCounts, reaction.childrenCounts) && Objects.equals(this.userData, reaction.userData) && Objects.equals(this.activityData, reaction.activityData) && Objects.equals(this.extra, reaction.extra) && Objects.equals(this.moderationTemplate, reaction.moderationTemplate) && Objects.equals(this.moderation, reaction.moderation);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.appID, this.kind, this.userID, this.activityID, this.parent, this.ownChildren, this.latestChildren, this.childrenCounts, this.userData, this.activityData, this.extra, this.moderationTemplate, this.moderation);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("appID", (Object)this.appID).add("kind", (Object)this.kind).add("userID", (Object)this.userID).add("activityID", (Object)this.activityID).add("parent", (Object)this.parent).add("ownChildren", this.ownChildren).add("latestChildren", this.latestChildren).add("childrenCounts", this.childrenCounts).add("userData", (Object)this.userData).add("activityData", this.activityData).add("extra", this.extra).add("moderationTemplate", (Object)this.moderationTemplate).add("moderation", this.moderation).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String id;
        private Integer appID;
        private String kind;
        private String userID;
        private String activityID;
        private String parent;
        private Map<String, List<Reaction>> ownChildren;
        private Map<String, List<Reaction>> latestChildren;
        private Map<String, Number> childrenCounts;
        private Data userData;
        private Map<String, Object> activityData;
        private Map<String, Object> extra;
        private String moderationTemplate;
        private Map<String, Object> moderation;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder appID(int appID) {
            this.appID = appID;
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        @JsonProperty(value="user_id")
        public Builder userID(String userID) {
            this.userID = userID;
            return this;
        }

        @JsonProperty(value="activity_id")
        public Builder activityID(String activityID) {
            this.activityID = activityID;
            return this;
        }

        public Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        @JsonProperty(value="own_children")
        public Builder ownChildren(Map<String, List<Reaction>> ownChildren) {
            this.ownChildren = ownChildren;
            return this;
        }

        @JsonProperty(value="latest_children")
        public Builder latestChildren(Map<String, List<Reaction>> latestChildren) {
            this.latestChildren = latestChildren;
            return this;
        }

        @JsonProperty(value="children_counts")
        public Builder childrenCounts(Map<String, Number> childrenCounts) {
            this.childrenCounts = childrenCounts;
            return this;
        }

        @JsonProperty(value="user")
        public Builder userData(Data userData) {
            this.userData = userData;
            return this;
        }

        @JsonAnySetter
        public Builder extraField(String key, Object value) {
            if (this.extra == null) {
                this.extra = Maps.newHashMap();
            }
            this.extra.put(key, value);
            return this;
        }

        @JsonProperty(value="data")
        public Builder activityData(Map<String, Object> activityData) {
            this.activityData = activityData;
            return this;
        }

        @JsonProperty(value="moderation_template")
        public Builder moderationTemplate(String moderationTemplate) {
            this.moderationTemplate = moderationTemplate;
            return this;
        }

        @JsonProperty(value="moderation")
        public Builder moderation(Map<String, Object> moderation) {
            this.moderation = moderation;
            return this;
        }

        @JsonIgnore
        public Builder extra(Map<String, Object> extra) {
            this.extra = extra;
            return this;
        }

        @JsonIgnore
        public Builder fromReaction(Reaction reaction) {
            this.id = reaction.id;
            this.appID = reaction.appID;
            this.kind = reaction.kind;
            this.userID = reaction.userID;
            this.activityID = reaction.activityID;
            this.parent = reaction.parent;
            this.ownChildren = reaction.ownChildren;
            this.latestChildren = reaction.latestChildren;
            this.childrenCounts = reaction.childrenCounts;
            this.userData = reaction.userData;
            this.activityData = reaction.activityData;
            this.extra = reaction.extra;
            this.moderationTemplate = reaction.moderationTemplate;
            this.moderation = reaction.moderation;
            return this;
        }

        @JsonIgnore
        public <T> Builder fromCustomReaction(T custom) {
            return this.fromReaction(Serialization.convert(custom, Reaction.class));
        }

        public Reaction build() {
            return new Reaction(this);
        }
    }
}

