/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.faye;

import com.google.common.base.MoreObjects;
import io.getstream.core.faye.Grammar;
import io.getstream.core.faye.Message;
import io.getstream.core.faye.emitter.EventEmitter;
import io.getstream.core.faye.emitter.EventListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Channel {
    public static final String HANDSHAKE = "/meta/handshake";
    public static final String CONNECT = "/meta/connect";
    public static final String DISCONNECT = "/meta/disconnect";
    public static final String SUBSCRIBE = "/meta/subscribe";
    public static final String UNSUBSCRIBE = "/meta/unsubscribe";
    private final String name;
    final EventEmitter<Message> eventEmitter = new EventEmitter();

    public Channel(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void bind(String event, EventListener<Message> listener) {
        this.eventEmitter.on(event, listener);
    }

    public void unbind(String event, EventListener<Message> listener) {
        this.eventEmitter.removeListener(event, listener);
    }

    public void trigger(String event, Message message) {
        this.eventEmitter.emit(event, message);
    }

    public boolean hasListeners(String event) throws Exception {
        return this.eventEmitter.hasListeners(event);
    }

    public static List<String> expand(String name) {
        ArrayList<String> channels = new ArrayList<String>(Arrays.asList("/**", name));
        List<String> segments = Channel.parse(name);
        if (segments == null) {
            return null;
        }
        List<String> copy = new ArrayList<String>(segments);
        copy.add(copy.size() - 1, "*");
        channels.add(Channel.unparse(copy));
        for (int i = 1; i < segments.size(); ++i) {
            copy = segments.subList(0, i);
            copy.add("**");
            channels.add(Channel.unparse(copy));
        }
        return channels;
    }

    public static boolean isValid(String name) {
        return Grammar.CHANNEL_NAME.matcher(name).matches() || Grammar.CHANNEL_PATTERN.matcher(name).matches();
    }

    public static List<String> parse(String name) {
        if (!Channel.isValid(name)) {
            return null;
        }
        String[] splits = name.split("/");
        return Arrays.asList(splits).subList(1, splits.length);
    }

    public static String unparse(List<String> segments) {
        String joinedSegments = String.join((CharSequence)"/", segments);
        return "/" + joinedSegments;
    }

    public static Boolean isMeta(String name) {
        List<String> segments = Channel.parse(name);
        if (segments == null) {
            return null;
        }
        return segments.get(0).equals("meta");
    }

    public static Boolean isService(String name) {
        List<String> segments = Channel.parse(name);
        if (segments == null) {
            return null;
        }
        return segments.get(0).equals("service");
    }

    public static Boolean isSubscribable(String name) {
        if (!Channel.isValid(name)) {
            return null;
        }
        Boolean isMeta = Channel.isMeta(name);
        Boolean isService = Channel.isService(name);
        if (isMeta == null || isService == null) {
            return null;
        }
        return isMeta == false && isService == false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel that = (Channel)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).toString();
    }
}

