/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.faye;

import com.google.common.base.MoreObjects;
import io.getstream.core.faye.Grammar;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class FayeClientError
extends Throwable {
    private final Integer code;
    private final List<String> params;
    private final String errorMessage;

    public FayeClientError(Integer code, List<String> params, String errorMessage) {
        this.code = code;
        this.params = params;
        this.errorMessage = errorMessage;
    }

    public static FayeClientError parse(String errorMessage) {
        if (errorMessage == null) {
            errorMessage = "";
        }
        if (!Grammar.ERROR.matcher(errorMessage).matches()) {
            return new FayeClientError(null, null, errorMessage);
        }
        List<String> parts = Arrays.asList(errorMessage.split(":"));
        Integer code = Integer.parseInt(parts.get(0));
        List<String> params = Arrays.asList(parts.get(1).split(","));
        String message = parts.get(2);
        return new FayeClientError(code, params, message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FayeClientError that = (FayeClientError)o;
        return Objects.equals(this.code, that.code) && Objects.equals(this.params, that.params) && Objects.equals(this.errorMessage, that.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.params, this.errorMessage);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("code", (Object)this.code).add("params", this.params).add("errorMessage", (Object)this.errorMessage).toString();
    }
}

