/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;

public class ProfileData {
    private final String id;
    private final int followingCount;
    private final int followersCount;
    private final Map<String, Object> data;

    @JsonCreator
    public ProfileData(@JsonProperty(value="id") String id, @JsonProperty(value="following_count") int followingCount, @JsonProperty(value="followers_count") int followersCount, @JsonProperty(value="data") Map<String, Object> data) {
        Preconditions.checkArgument((followersCount >= 0 ? 1 : 0) != 0, (Object)"Can't have negative followers count");
        Preconditions.checkArgument((followingCount >= 0 ? 1 : 0) != 0, (Object)"Can't have negative following count");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"ID required");
        this.followingCount = followingCount;
        this.followersCount = followersCount;
        this.data = (Map)Preconditions.checkNotNull(data, (Object)"Can't have null data");
    }

    public String getID() {
        return this.id;
    }

    @JsonProperty(value="followers_count")
    public int getFollowersCount() {
        return this.followersCount;
    }

    @JsonProperty(value="following_count")
    public int getFollowingCount() {
        return this.followingCount;
    }

    @JsonAnyGetter
    public Map<String, Object> getData() {
        return this.data;
    }

    public <T> T get(String key) {
        return (T)this.data.get(Preconditions.checkNotNull((Object)key, (Object)"Key can't be null"));
    }

    @JsonAnySetter
    public <T> ProfileData set(String key, T value) {
        Preconditions.checkArgument((!"id".equals(key) ? 1 : 0) != 0, (Object)"Key can't be named 'id'");
        Preconditions.checkNotNull((Object)key, (Object)"Key can't be null");
        this.data.put(key, value);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileData data = (ProfileData)o;
        return Objects.equals(this.id, data.id) && this.followersCount == data.followersCount && this.followingCount == data.followingCount && Objects.equals(data, data.data);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("data", this.data).toString();
    }
}

