/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import io.getstream.client.QueryAuditLogsFilters;
import io.getstream.client.QueryAuditLogsPager;
import io.getstream.client.QueryAuditLogsResponse;
import io.getstream.core.Stream;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Token;
import io.getstream.core.options.CustomQueryParameter;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Auth;
import java.util.ArrayList;
import java8.util.concurrent.CompletableFuture;

public final class AuditLogsClient {
    private final String secret;
    private final Stream stream;

    public AuditLogsClient(String secret, Stream stream) {
        this.secret = secret;
        this.stream = stream;
    }

    public CompletableFuture<QueryAuditLogsResponse> queryAuditLogs(QueryAuditLogsFilters filters) throws StreamException {
        return this.queryAuditLogs(filters, new QueryAuditLogsPager());
    }

    public CompletableFuture<QueryAuditLogsResponse> queryAuditLogs(QueryAuditLogsFilters filters, QueryAuditLogsPager pager) throws StreamException {
        if (filters == null) {
            throw new StreamException("Filters cannot be null for audit logs queries");
        }
        Token token = Auth.buildAuditLogsToken(this.secret, Auth.TokenAction.READ);
        RequestOption[] options = this.buildRequestOptions(filters, pager);
        return this.stream.queryAuditLogs(token, options);
    }

    private RequestOption[] buildRequestOptions(QueryAuditLogsFilters filters, QueryAuditLogsPager pager) {
        ArrayList<CustomQueryParameter> options = new ArrayList<CustomQueryParameter>();
        if (filters.getEntityType() != null && !filters.getEntityType().isEmpty() && filters.getEntityID() != null && !filters.getEntityID().isEmpty()) {
            options.add(new CustomQueryParameter("entity_type", filters.getEntityType()));
            options.add(new CustomQueryParameter("entity_id", filters.getEntityID()));
        }
        if (filters.getUserID() != null && !filters.getUserID().isEmpty()) {
            options.add(new CustomQueryParameter("user_id", filters.getUserID()));
        }
        if (pager != null) {
            if (pager.getNext() != null && !pager.getNext().isEmpty()) {
                options.add(new CustomQueryParameter("next", pager.getNext()));
            }
            if (pager.getPrev() != null && !pager.getPrev().isEmpty()) {
                options.add(new CustomQueryParameter("prev", pager.getPrev()));
            }
            if (pager.getLimit() > 0) {
                options.add(new CustomQueryParameter("limit", Integer.toString(pager.getLimit())));
            }
        }
        return options.toArray(new RequestOption[0]);
    }
}

