/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.cloud;

import com.fasterxml.jackson.core.type.TypeReference;
import io.getstream.cloud.CloudClient;
import io.getstream.cloud.CloudFeed;
import io.getstream.cloud.FeedSubscriber;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.models.Activity;
import io.getstream.core.models.EnrichedActivity;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.PaginatedNotificationGroup;
import io.getstream.core.options.ActivityMarker;
import io.getstream.core.options.EnrichmentFlags;
import io.getstream.core.options.Filter;
import io.getstream.core.options.Limit;
import io.getstream.core.options.Offset;
import io.getstream.core.utils.DefaultOptions;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java8.util.concurrent.CompletableFuture;
import java8.util.concurrent.CompletionException;

public final class CloudNotificationFeed
extends CloudFeed {
    CloudNotificationFeed(CloudClient client, FeedID id) {
        super(client, id);
    }

    CloudNotificationFeed(CloudClient client, FeedID id, FeedSubscriber subscriber) {
        super(client, id, subscriber);
    }

    public CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities() throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities(Limit limit) throws StreamException {
        return this.getActivities(limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities(Offset offset) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities(Filter filter) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities(ActivityMarker marker) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities(Limit limit, Offset offset) throws StreamException {
        return this.getActivities(limit, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities(Limit limit, Filter filter) throws StreamException {
        return this.getActivities(limit, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities(Limit limit, ActivityMarker marker) throws StreamException {
        return this.getActivities(limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities(Filter filter, ActivityMarker marker) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, marker);
    }

    public CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities(Offset offset, ActivityMarker marker) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities(Limit limit, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getActivities(limit, DefaultOptions.DEFAULT_OFFSET, filter, marker);
    }

    public CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities(Limit limit, Offset offset, ActivityMarker marker) throws StreamException {
        return this.getActivities(limit, offset, DefaultOptions.DEFAULT_FILTER, marker);
    }

    CompletableFuture<PaginatedNotificationGroup<Activity>> getActivities(Limit limit, Offset offset, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getClient().getActivities(this.getID(), limit, offset, filter, marker).thenApply(response -> {
            try {
                return Serialization.deserialize(response, new TypeReference<PaginatedNotificationGroup<Activity>>(){});
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type, Limit limit) throws StreamException {
        return this.getCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type, Offset offset) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type, Filter filter) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type, Limit limit, Offset offset) throws StreamException {
        return this.getCustomActivities(type, limit, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type, Limit limit, Filter filter) throws StreamException {
        return this.getCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type, Limit limit, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, marker);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type, Offset offset, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type, Limit limit, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, filter, marker);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type, Limit limit, Offset offset, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, limit, offset, DefaultOptions.DEFAULT_FILTER, marker);
    }

    <T> CompletableFuture<PaginatedNotificationGroup<T>> getCustomActivities(Class<T> type, Limit limit, Offset offset, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getClient().getActivities(this.getID(), limit, offset, filter, marker).thenApply(response -> {
            try {
                return (PaginatedNotificationGroup)Serialization.deserialize(response, new TypeReference<PaginatedNotificationGroup<T>>(){});
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities() throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Offset offset) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Filter filter) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(ActivityMarker marker) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit, Offset offset) throws StreamException {
        return this.getEnrichedActivities(limit, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit, Filter filter) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit, ActivityMarker marker) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Offset offset, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, marker, flags);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Filter filter, ActivityMarker marker) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Offset offset, ActivityMarker marker) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit, Offset offset, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(limit, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit, Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, marker, flags);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, filter, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit, Offset offset, ActivityMarker marker) throws StreamException {
        return this.getEnrichedActivities(limit, offset, DefaultOptions.DEFAULT_FILTER, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Filter filter, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, marker, flags);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Offset offset, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, marker, flags);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit, Filter filter, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, filter, marker, flags);
    }

    public CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit, Offset offset, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(limit, offset, DefaultOptions.DEFAULT_FILTER, marker, flags);
    }

    CompletableFuture<PaginatedNotificationGroup<EnrichedActivity>> getEnrichedActivities(Limit limit, Offset offset, Filter filter, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getClient().getEnrichedActivities(this.getID(), limit, offset, filter, marker, flags).thenApply(response -> {
            try {
                return Serialization.deserialize(response, new TypeReference<PaginatedNotificationGroup<EnrichedActivity>>(){});
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Offset offset) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Filter filter) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, ActivityMarker marker) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Offset offset) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Filter filter) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, ActivityMarker marker) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Offset offset, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, marker, flags);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Offset offset, ActivityMarker marker) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Offset offset, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, marker, flags);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, filter, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Offset offset, ActivityMarker marker) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, offset, DefaultOptions.DEFAULT_FILTER, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Filter filter, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, marker, flags);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Offset offset, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, marker, flags);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Filter filter, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, filter, marker, flags);
    }

    public <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Offset offset, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, offset, DefaultOptions.DEFAULT_FILTER, marker, flags);
    }

    <T> CompletableFuture<PaginatedNotificationGroup<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Offset offset, Filter filter, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getClient().getEnrichedActivities(this.getID(), limit, offset, filter, marker, flags).thenApply(response -> {
            try {
                return (PaginatedNotificationGroup)Serialization.deserialize(response, new TypeReference<PaginatedNotificationGroup<T>>(){});
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }
}

