/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.cloud;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.getstream.cloud.CloudClient;
import io.getstream.cloud.CloudFlatFeed;
import io.getstream.cloud.FeedSubscriber;
import io.getstream.cloud.RealtimeMessageCallback;
import io.getstream.core.KeepHistory;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.faye.subscription.ChannelSubscription;
import io.getstream.core.models.Activity;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.FollowRelation;
import io.getstream.core.options.CustomQueryParameter;
import io.getstream.core.options.Limit;
import io.getstream.core.options.Offset;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.DefaultOptions;
import io.getstream.core.utils.Serialization;
import io.getstream.core.utils.Streams;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java8.util.J8Arrays;
import java8.util.concurrent.CompletableFuture;
import java8.util.concurrent.CompletionException;

public class CloudFeed {
    private final CloudClient client;
    private final FeedID id;
    private final FeedSubscriber subscriber;

    CloudFeed(CloudClient client, FeedID id) {
        Preconditions.checkNotNull((Object)client, (Object)"Can't create feed w/o a client");
        Preconditions.checkNotNull((Object)id, (Object)"Can't create feed w/o an ID");
        this.client = client;
        this.id = id;
        this.subscriber = null;
    }

    CloudFeed(CloudClient client, FeedID id, FeedSubscriber subscriber) {
        Preconditions.checkNotNull((Object)client, (Object)"Can't create feed w/o a client");
        Preconditions.checkNotNull((Object)id, (Object)"Can't create feed w/o an ID");
        this.client = client;
        this.id = id;
        this.subscriber = subscriber;
    }

    protected final CloudClient getClient() {
        return this.client;
    }

    public final CompletableFuture<ChannelSubscription> subscribe(RealtimeMessageCallback messageCallback) {
        Preconditions.checkNotNull((Object)this.subscriber, (Object)"A subscriber must be provided in order to start listening to a feed");
        return this.subscriber.subscribe(this.id, messageCallback);
    }

    public final FeedID getID() {
        return this.id;
    }

    public final String getSlug() {
        return this.id.getSlug();
    }

    public final String getUserID() {
        return this.id.getUserID();
    }

    public final CompletableFuture<Activity> addActivity(Activity activity) throws StreamException {
        return this.getClient().addActivity(this.id, activity).thenApply(response -> {
            try {
                return Serialization.deserialize(response, Activity.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public final <T> CompletableFuture<T> addCustomActivity(T activity) throws StreamException {
        return this.getClient().addActivity(this.id, Activity.builder().fromCustomActivity(activity).build()).thenApply(response -> {
            try {
                return Serialization.deserialize(response, activity.getClass());
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public final CompletableFuture<List<Activity>> addActivities(Iterable<Activity> activities) throws StreamException {
        return this.addActivities((Activity[])Iterables.toArray(activities, Activity.class));
    }

    public final <T> CompletableFuture<List<T>> addCustomActivities(Iterable<T> activities) throws StreamException {
        Activity[] custom = (Activity[])Streams.stream(activities).map(activity -> Activity.builder().fromCustomActivity(activity).build()).toArray(Activity[]::new);
        return this.getClient().addActivities(this.id, custom).thenApply(response -> {
            try {
                Class element = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
                return Serialization.deserializeContainer(response, "activities", element);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public final CompletableFuture<List<Activity>> addActivities(Activity ... activities) throws StreamException {
        return this.getClient().addActivities(this.id, activities).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, "activities", Activity.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public final <T> CompletableFuture<List<T>> addCustomActivities(T ... activities) throws StreamException {
        Activity[] custom = (Activity[])J8Arrays.stream((Object[])activities).map(activity -> Activity.builder().fromCustomActivity(activity).build()).toArray(Activity[]::new);
        return this.getClient().addActivities(this.id, custom).thenApply(response -> {
            try {
                Class<?> element = activities.getClass().getComponentType();
                return Serialization.deserializeContainer(response, "activities", element);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public final CompletableFuture<Void> removeActivityByID(String id) throws StreamException {
        return this.client.removeActivityByID(this.id, id).thenApply(response -> {
            try {
                return Serialization.deserializeError(response);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public final CompletableFuture<Void> removeActivityByForeignID(String foreignID) throws StreamException {
        return this.client.removeActivityByForeignID(this.id, foreignID).thenApply(response -> {
            try {
                return Serialization.deserializeError(response);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public final CompletableFuture<Void> follow(CloudFlatFeed feed) throws StreamException {
        return this.follow(feed, 100);
    }

    public final CompletableFuture<Void> follow(CloudFlatFeed feed, int activityCopyLimit) throws StreamException {
        Preconditions.checkArgument((activityCopyLimit <= 1000 ? 1 : 0) != 0, (Object)String.format("Activity copy limit should be less then %d", 1000));
        return this.client.follow(this.id, feed.getID(), activityCopyLimit).thenApply(response -> {
            try {
                return Serialization.deserializeError(response);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowers(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(FeedID ... feedIDs) throws StreamException {
        return this.getFollowers(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, feedIDs);
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Limit limit, Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowers(limit, DefaultOptions.DEFAULT_OFFSET, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Limit limit, FeedID ... feedIDs) throws StreamException {
        return this.getFollowers(limit, DefaultOptions.DEFAULT_OFFSET, feedIDs);
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Offset offset, Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowers(DefaultOptions.DEFAULT_LIMIT, offset, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Offset offset, FeedID ... feedIDs) throws StreamException {
        return this.getFollowers(DefaultOptions.DEFAULT_LIMIT, offset, feedIDs);
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Limit limit, Offset offset, Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowers(limit, offset, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Limit limit, Offset offset, FeedID ... feeds) throws StreamException {
        RequestOption[] requestOptionArray;
        Preconditions.checkNotNull((Object)feeds, (Object)"No feed ids to filter on");
        CharSequence[] feedIDs = (String[])J8Arrays.stream((Object[])feeds).map(id -> id.toString()).toArray(String[]::new);
        if (feedIDs.length == 0) {
            RequestOption[] requestOptionArray2 = new RequestOption[2];
            requestOptionArray2[0] = limit;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[1] = offset;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[3];
            requestOptionArray3[0] = limit;
            requestOptionArray3[1] = offset;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[2] = new CustomQueryParameter("filter", String.join((CharSequence)",", feedIDs));
        }
        RequestOption[] options = requestOptionArray;
        return this.client.getFollowers(this.id, options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, FollowRelation.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowed(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(FeedID ... feedIDs) throws StreamException {
        return this.getFollowed(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, feedIDs);
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Limit limit, Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowed(limit, DefaultOptions.DEFAULT_OFFSET, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Limit limit, FeedID ... feedIDs) throws StreamException {
        return this.getFollowed(limit, DefaultOptions.DEFAULT_OFFSET, feedIDs);
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Offset offset, Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowed(DefaultOptions.DEFAULT_LIMIT, offset, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Offset offset, FeedID ... feedIDs) throws StreamException {
        return this.getFollowed(DefaultOptions.DEFAULT_LIMIT, offset, feedIDs);
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Limit limit, Offset offset, Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowed(limit, offset, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Limit limit, Offset offset, FeedID ... feeds) throws StreamException {
        RequestOption[] requestOptionArray;
        Preconditions.checkNotNull((Object)feeds, (Object)"No feed ids to filter on");
        CharSequence[] feedIDs = (String[])J8Arrays.stream((Object[])feeds).map(id -> id.toString()).toArray(String[]::new);
        if (feedIDs.length == 0) {
            RequestOption[] requestOptionArray2 = new RequestOption[2];
            requestOptionArray2[0] = limit;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[1] = offset;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[3];
            requestOptionArray3[0] = limit;
            requestOptionArray3[1] = offset;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[2] = new CustomQueryParameter("filter", String.join((CharSequence)",", feedIDs));
        }
        RequestOption[] options = requestOptionArray;
        return this.client.getFollowed(this.id, options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, FollowRelation.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public final CompletableFuture<Void> unfollow(CloudFlatFeed feed) throws StreamException {
        return this.unfollow(feed, KeepHistory.NO);
    }

    public final CompletableFuture<Void> unfollow(CloudFlatFeed feed, KeepHistory keepHistory) throws StreamException {
        return this.client.unfollow(this.id, feed.getID(), new io.getstream.core.options.KeepHistory(keepHistory)).thenApply(response -> {
            try {
                return Serialization.deserializeError(response);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }
}

