/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.faye.client;

import io.getstream.core.faye.Advice;
import io.getstream.core.faye.Channel;
import io.getstream.core.faye.DefaultMessageTransformer;
import io.getstream.core.faye.FayeClientError;
import io.getstream.core.faye.Message;
import io.getstream.core.faye.MessageTransformer;
import io.getstream.core.faye.client.Callback;
import io.getstream.core.faye.client.FayeClientState;
import io.getstream.core.faye.client.MessageCallback;
import io.getstream.core.faye.client.StateChangeListener;
import io.getstream.core.faye.subscription.ChannelDataCallback;
import io.getstream.core.faye.subscription.ChannelSubscription;
import io.getstream.core.faye.subscription.SubscriptionCancelledCallback;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class FayeClient
extends WebSocketListener {
    private static final String BAYEUX_VERSION = "1.0";
    private static final int DEFAULT_TIMEOUT = 60;
    private static final int DEFAULT_INTERVAL = 0;
    private final String baseURL;
    private final int timeout;
    private final int interval;
    private Advice advice;
    private String clientId;
    private final Map<String, Channel> channels = new HashMap<String, Channel>();
    private final Map<String, MessageCallback> responseCallbacks = new HashMap<String, MessageCallback>();
    private MessageTransformer messageTransformer = new DefaultMessageTransformer();
    private FayeClientState state = FayeClientState.UNCONNECTED;
    private StateChangeListener stateChangeListener;
    private WebSocket webSocket;
    private final OkHttpClient httpClient = new OkHttpClient();
    private Timer timer = new Timer();
    private boolean manuallyClosed = false;
    private boolean connectRequestInProgress = false;
    private final String EVENT_MESSAGE = "message";
    private int messageId = 0;

    public FayeClient(URL baseURL) {
        String url = baseURL.toString();
        if (url.startsWith("https")) {
            url = url.replace("https", "wss");
        } else if (url.startsWith("http")) {
            url = url.replace("http", "ws");
        }
        this.baseURL = url;
        this.timeout = 60;
        this.interval = 0;
        this.advice = new Advice("retry", 1000 * this.interval, 1000 * this.timeout);
    }

    public void setMessageTransformer(MessageTransformer messageTransformer) {
        this.messageTransformer = messageTransformer;
    }

    private void setState(FayeClientState state) {
        this.state = state;
        if (this.stateChangeListener != null) {
            this.stateChangeListener.onStateChanged(state);
        }
    }

    public void setStateChangeListener(StateChangeListener stateChangeListener) {
        this.stateChangeListener = stateChangeListener;
    }

    private void initWebSocket() {
        if (this.webSocket != null) {
            this.closeWebSocket();
        }
        Request request = new Request.Builder().url(this.baseURL).build();
        this.webSocket = this.httpClient.newWebSocket(request, (WebSocketListener)this);
    }

    private void closeWebSocket() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.webSocket != null) {
            this.webSocket.close(1000, "Connection closed by client");
            this.webSocket = null;
        }
    }

    public void onMessage(WebSocket webSocket, String text) {
        List<Message> messages = null;
        try {
            messages = Serialization.fromJSONList(text, Message.class);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (messages == null) {
            return;
        }
        for (Message message : messages) {
            this.receiveMessage(message);
        }
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.closeWebSocket();
        this.initWebSocket();
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.closeWebSocket();
        if (this.manuallyClosed) {
            return;
        }
        this.initWebSocket();
    }

    private void scheduleTimerTask(final Callback callback, long duration) {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                callback.call();
            }
        }, duration);
    }

    public void handshake() {
        this.handshake(null);
    }

    private void handshake(Callback callback) {
        if (Objects.equals(this.advice.getReconnect(), "none")) {
            return;
        }
        if (this.state != FayeClientState.UNCONNECTED) {
            return;
        }
        this.setState(FayeClientState.CONNECTING);
        this.initWebSocket();
        String[] connectionTypes = new String[]{"websocket"};
        Message message = new Message("/meta/handshake");
        message.setVersion(BAYEUX_VERSION);
        message.setSupportedConnectionTypes(connectionTypes);
        this.sendMessage(message, response -> {
            if (response.isSuccessful() != null && response.isSuccessful().booleanValue()) {
                this.setState(FayeClientState.CONNECTED);
                this.clientId = response.getClientId();
                Set<String> keys = this.channels.keySet();
                this.subscribeChannels(keys.toArray(new String[0]));
                if (callback != null) {
                    callback.call();
                }
            } else {
                this.scheduleTimerTask(() -> this.handshake(callback), 1000L);
                this.setState(FayeClientState.UNCONNECTED);
            }
        });
    }

    public void connect() {
        this.connect(null);
    }

    private void connect(Callback callback) {
        if (Objects.equals(this.advice.getReconnect(), "none")) {
            return;
        }
        if (this.state == FayeClientState.DISCONNECTED) {
            return;
        }
        if (this.state == FayeClientState.UNCONNECTED) {
            this.handshake(() -> this.connect(callback));
            return;
        }
        if (callback != null) {
            callback.call();
        }
        if (this.state != FayeClientState.CONNECTED) {
            return;
        }
        if (this.connectRequestInProgress) {
            return;
        }
        this.connectRequestInProgress = true;
        Message message = new Message("/meta/connect");
        message.setClientId(this.clientId);
        message.setConnectionType("websocket");
        this.sendMessage(message, response -> this.cycleConnection());
    }

    public CompletableFuture<Void> disconnect() {
        CompletableFuture<Void> disconnectionCompleter = new CompletableFuture<Void>();
        if (this.state != FayeClientState.CONNECTED) {
            disconnectionCompleter.complete(null);
        }
        this.setState(FayeClientState.DISCONNECTED);
        Message message = new Message("/meta/disconnect");
        message.setClientId(this.clientId);
        this.sendMessage(message, response -> {
            if (response.isSuccessful() != null && response.isSuccessful().booleanValue()) {
                this.manuallyClosed = true;
                this.closeWebSocket();
                disconnectionCompleter.complete(null);
            } else {
                FayeClientError error = FayeClientError.parse(response.getError());
                disconnectionCompleter.completeExceptionally(error);
            }
        });
        this.channels.clear();
        return disconnectionCompleter;
    }

    private void subscribeChannels(String[] channels) {
        for (String channel : channels) {
            this.subscribe(channel, true);
        }
    }

    public CompletableFuture<ChannelSubscription> subscribe(String channel, ChannelDataCallback callback) {
        return this.subscribe(channel, callback, null, null);
    }

    private CompletableFuture<ChannelSubscription> subscribe(String channel, Boolean force) {
        return this.subscribe(channel, null, null, force);
    }

    public CompletableFuture<ChannelSubscription> subscribe(String channel, ChannelDataCallback callback, SubscriptionCancelledCallback onCancelled) {
        return this.subscribe(channel, callback, onCancelled, null);
    }

    private CompletableFuture<ChannelSubscription> subscribe(String channel, ChannelDataCallback onData, SubscriptionCancelledCallback onCancelled, Boolean force) {
        if (force == null) {
            force = false;
        }
        CompletableFuture<ChannelSubscription> subscriptionCompleter = new CompletableFuture<ChannelSubscription>();
        ChannelSubscription channelSubscription = new ChannelSubscription(this, channel, onData, onCancelled);
        boolean hasSubscribe = this.channels.containsKey(channel);
        if (hasSubscribe && !force.booleanValue()) {
            this.subscribeChannel(channel, channelSubscription);
            subscriptionCompleter.complete(channelSubscription);
        } else {
            Boolean finalForce = force;
            this.connect(() -> {
                if (!finalForce.booleanValue()) {
                    this.subscribeChannel(channel, channelSubscription);
                }
                Message message = new Message("/meta/subscribe");
                message.setClientId(this.clientId);
                message.setSubscription(channel);
                this.sendMessage(message, response -> {
                    if (response.isSuccessful() != null && response.isSuccessful().booleanValue()) {
                        String subscribedChannel = response.getSubscription();
                        subscriptionCompleter.complete(channelSubscription);
                    } else {
                        this.unsubscribeChannel(channel, channelSubscription);
                        FayeClientError error = FayeClientError.parse(response.getError());
                        subscriptionCompleter.completeExceptionally(error);
                    }
                });
            });
        }
        return subscriptionCompleter;
    }

    public void unsubscribe(String channel, ChannelSubscription channelSubscription) {
        boolean dead = this.unsubscribeChannel(channel, channelSubscription);
        if (!dead) {
            return;
        }
        this.connect(() -> {
            Message message = new Message("/meta/unsubscribe");
            message.setClientId(this.clientId);
            message.setSubscription(channel);
            this.sendMessage(message, response -> {
                if (response.isSuccessful() != null && response.isSuccessful().booleanValue()) {
                    String string = response.getSubscription();
                }
            });
        });
    }

    public CompletableFuture<Void> publish(String channel, Map<String, Object> data) {
        CompletableFuture<Void> publishCompleter = new CompletableFuture<Void>();
        this.connect(() -> {
            Message message = new Message(channel);
            message.setData(data);
            message.setClientId(this.clientId);
            this.sendMessage(message, response -> {
                if (response.isSuccessful() != null && response.isSuccessful().booleanValue()) {
                    publishCompleter.complete(null);
                } else {
                    FayeClientError error = FayeClientError.parse(response.getError());
                    publishCompleter.completeExceptionally(error);
                }
            });
        });
        return publishCompleter;
    }

    private void subscribeChannel(String name, ChannelSubscription channelSubscription) {
        Channel channel;
        if (this.channels.containsKey(name)) {
            channel = this.channels.get(name);
        } else {
            channel = new Channel(name);
            this.channels.put(name, channel);
        }
        channel.bind("message", channelSubscription::call);
    }

    private boolean unsubscribeChannel(String name, ChannelSubscription channelSubscription) {
        Channel channel = this.channels.get(name);
        if (channel == null) {
            return false;
        }
        channel.unbind("message", channelSubscription::call);
        try {
            if (channel.hasListeners("message")) {
                this.channels.remove(name);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void distributeChannelMessage(Message message) {
        List<String> expandedChannels = Channel.expand(message.getChannel());
        if (expandedChannels == null) {
            return;
        }
        for (String c : expandedChannels) {
            Channel channel = this.channels.get(c);
            if (channel == null) continue;
            channel.trigger("message", message);
        }
    }

    private String generateMessageId() {
        ++this.messageId;
        if ((double)this.messageId >= Math.pow(2.0, 32.0)) {
            this.messageId = 0;
        }
        return Integer.toString(this.messageId, 36);
    }

    private void sendMessage(Message message) {
        this.sendMessage(message, null);
    }

    private void sendMessage(Message message, MessageCallback onResponse) {
        String id = this.generateMessageId();
        message.setId(id);
        message = this.messageTransformer.transformRequest(message);
        if (onResponse != null) {
            this.responseCallbacks.put(id, onResponse);
        }
        try {
            byte[] payload = Serialization.toJSON(message);
            this.webSocket.send(new String(payload));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void receiveMessage(Message message) {
        String id = message.getId();
        MessageCallback callback = null;
        if (message.isSuccessful() != null) {
            callback = this.responseCallbacks.remove(id);
        }
        if ((message = this.messageTransformer.transformResponse(message)).getAdvice() != null) {
            this.handleAdvice(message.getAdvice());
        }
        this.deliverMessage(message);
        if (callback != null) {
            callback.onMessage(message);
        }
    }

    private void handleAdvice(Advice advice) {
        this.advice = advice;
        if (Objects.equals(advice.getReconnect(), "handshake") && this.state != FayeClientState.DISCONNECTED) {
            this.setState(FayeClientState.UNCONNECTED);
            this.clientId = null;
            this.cycleConnection();
        }
    }

    private void deliverMessage(Message message) {
        if (message.getChannel() == null || message.getData() == null) {
            return;
        }
        this.distributeChannelMessage(message);
    }

    private void cycleConnection() {
        if (this.connectRequestInProgress) {
            this.connectRequestInProgress = false;
        }
        this.scheduleTimerTask(this::connect, this.advice.getInterval().intValue());
    }
}

